/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class RecentChangeTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/recentchange.dump";
    }

    @Test
    public void testRecursive() throws DbException {
        RecentChangesParams2 params = new RecentChangesParams2();
        params.setBasePath(new Path((CharSequence)"trunk/dir2"));
        params.setMaxReturn(10);
        Map<String, ChangeSet> changeSets = this.getChangeSetMap(this.cache.findRecentChangeSets(params));
        changeSets = this.getChangeSetMap(this.cache.findRecentChangeSets(params));
        Assert.assertEquals((String)"Unexpected results in recent test", (int)2, (int)changeSets.size());
        Assert.assertTrue((String)"Changeset is missing from list", (boolean)changeSets.containsKey("4"));
        Assert.assertTrue((String)"Changeset is missing from list", (boolean)changeSets.containsKey("2"));
        Assert.assertFalse((String)"Changeset in list but should not be", (boolean)changeSets.containsKey("3"));
    }

    private Map<String, ChangeSet> getChangeSetMap(List<ChangeSet> changeSets) {
        HashMap<String, ChangeSet> changeSetsById = new HashMap<String, ChangeSet>();
        for (ChangeSet changeSet : changeSets) {
            changeSetsById.put(changeSet.getId(), changeSet);
        }
        return changeSetsById;
    }
}

