/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.scmapi.ScmConfig;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config1.RepositoryType;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.activity.ActivityLog;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import com.cenqua.fisheye.svn.SvnScmConfig;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.svn.SvnTestHarness;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.util.RecentHistory;
import com.cenqua.fisheye.util.RegexMatcher;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public abstract class PropertyTestBase
extends SvnTestBase {
    private FishEyeSysProps.SvnPropertiesOnAdd oldSvnPropertiesOnAdd;

    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/props.dump";
    }

    protected FishEyeSysProps.SvnPropertiesOnAdd getSvnPropertiesOnAdd() {
        return FishEyeSysProps.SvnPropertiesOnAdd.Always;
    }

    @Override
    public void setUp() throws Exception {
        this.oldSvnPropertiesOnAdd = FishEyeSysProps.SVN_PROPERTIES_ON_ADD;
        FishEyeSysProps.SVN_PROPERTIES_ON_ADD = this.getSvnPropertiesOnAdd();
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        FishEyeSysProps.SVN_PROPERTIES_ON_ADD = this.oldSvnPropertiesOnAdd;
    }

    @Test
    public void testPropertyChangesBetweenCommits() throws DbException {
        FileHistory history = this.cache.getFileHistory(new Path((CharSequence)"/trunk/test.txt"));
        this.assertSCCSProp((SvnRevInfo)history.getRevision("2"), "1.1");
        this.assertSCCSProp((SvnRevInfo)history.getRevision("3"), "1.1");
        this.assertSCCSProp((SvnRevInfo)history.getRevision("4"), "1.2");
        this.assertSCCSProp((SvnRevInfo)history.getRevision("5"), "1.3");
    }

    @Test
    public void testBranchHasPropertiesSetInPreviousCommits() throws DbException {
        FileHistory history = this.cache.getFileHistory(new Path((CharSequence)"/branches/1.0/test.txt"));
        this.assertSCCSProp((SvnRevInfo)history.getRevision("6"), "1.3");
    }

    @Test
    public void testBranchHasPropertiesSetInBranchCopyCommit() throws DbException {
        SvnRevInfo fileRevision = this.cache.getLatestFileRevision(new Path((CharSequence)"/branches/2.0/test.txt"));
        Assert.assertThat((Object)fileRevision.getProperties(), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"svn:mime-type"), (Matcher)Matchers.is((Object)"text/html")));
    }

    @Test
    public void testFileHasPropertiesSetInCopyCommit() throws DbException {
        SvnRevInfo fileRevision = this.cache.getLatestFileRevision(new Path((CharSequence)"/branches/2.0/test-copy.txt"));
        Assert.assertThat((Object)fileRevision.getProperties(), (Matcher)Matchers.hasEntry((Matcher)Matchers.is((Object)"svn:mime-type"), (Matcher)Matchers.is((Object)"text/css")));
    }

    private void assertSCCSProp(SvnRevInfo revInfo, String requiredValue) {
        Map props = revInfo.getProperties();
        junit.framework.Assert.assertEquals((String)"Map should contain only 1 property", (int)1, (int)props.size());
        junit.framework.Assert.assertTrue((String)"SCCS Property value not found", (boolean)props.containsKey("SCCS"));
        junit.framework.Assert.assertEquals((String)"Property value is incorrect", (Object)requiredValue, props.get("SCCS"));
    }

    protected Matcher<ActivityLog> proplistForRevision(int revision) {
        return this.activityLogMatcher("proplist.*\\s+-r\\s+" + revision);
    }

    protected Matcher<ActivityLog> activityLogMatcher(String activityRegex) {
        return Matchers.hasProperty((String)"activity", (Matcher)RegexMatcher.regex(activityRegex));
    }

    @Override
    protected SvnTestHarness createHarness() {
        return new SvnTestHarness(){

            @Override
            protected RepositoryConfig createRepositoryConfig(RepositoryType repoDef, SvnScmConfig svnConfig) {
                return new RepositoryConfig(this.getRootConfig(), repoDef, (ScmConfig)svnConfig, (LicenseEnforcer)new NullLicenseEnforcer(), null){
                    private RepositoryStatus repositoryStatus;
                    private RecentHistory recentHistory;
                    {
                        this.recentHistory = new RecentHistory(10000);
                    }

                    public RepositoryStatus getStatus() {
                        if (this.repositoryStatus == null) {
                            this.repositoryStatus = new RepositoryStatus(this.getName()){

                                public RecentHistory getRecentActivities() {
                                    return recentHistory;
                                }
                            };
                        }
                        return this.repositoryStatus;
                    }
                };
            }
        };
    }
}

