/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.SvnSymbolicRuleType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.svn.db.SvnRevInfoDAO;
import junit.framework.Assert;
import org.junit.Test;

public class ProjectTagSrcTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/projecttagsrc.dump";
    }

    @Override
    protected SvnSymbolicType getPathMatcher() {
        SvnSymbolicType symbol = SvnSymbolicType.Factory.newInstance();
        SvnSymbolicRuleType trunk = symbol.addNewTrunk();
        trunk.setName("trunk");
        trunk.setRegex("projects/([^/]+)/trunk(/|$)");
        trunk.setLogical("${1}");
        SvnSymbolicRuleType branch = symbol.addNewBranch();
        branch.setName("${1}-${2}");
        branch.setRegex("projects/([^/]+)/branches(/|$)");
        branch.setLogical("${1}");
        SvnSymbolicRuleType tag = symbol.addNewTag();
        tag.setName("${1}-${2}");
        tag.setRegex("projects/([^/]+)/tags(/|$)");
        tag.setLogical("${1}");
        return symbol;
    }

    @Test
    public void testTagAsBranchSource() throws Exception {
        SvnRevInfoDAO dao = this.cache.getFileRevisionDAO();
        long latestCSID = dao.getLatestPathChange(new Path((CharSequence)"/projects/prj1/branches/br1/dir1/test.txt"));
        Assert.assertEquals((String)"The tag to branch path was not copied correctly, csid incorrect", (long)5L, (long)latestCSID);
    }
}

