/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.apache.subversion.javahl.ClientException;
import org.junit.Test;

public class MultiLevelTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/multilevel.dump";
    }

    @Override
    protected SvnSymbolicType getPathMatcher() {
        return SvnSymbolicType.Factory.newInstance();
    }

    @Override
    protected String getSubPath() {
        return "trunk/dir";
    }

    @Test
    public void testNonRootBase() throws IOException, ClientException, DbException, ConfigException {
        RecentChangesParams2 params = new RecentChangesParams2();
        params.setMaxReturn(10);
        List changeSets = this.cache.findRecentChangeSets(params);
        HashMap<String, ChangeSet> changeSetsById = new HashMap<String, ChangeSet>();
        for (ChangeSet changeSet : changeSets) {
            changeSetsById.put(changeSet.getId(), changeSet);
        }
        Assert.assertEquals((String)"Num changes sets incorrect", (int)3, (int)changeSetsById.size());
        Assert.assertTrue((String)"Changeset is missing from list", (boolean)changeSetsById.containsKey("2"));
        Assert.assertTrue((String)"Changeset is missing from list", (boolean)changeSetsById.containsKey("4"));
        Assert.assertTrue((String)"Changeset is missing from list", (boolean)changeSetsById.containsKey("5"));
        HashMap<Path, FileRevision> revMap = new HashMap<Path, FileRevision>();
        ChangeSet comboChange = (ChangeSet)changeSetsById.get("5");
        for (int i = 0; i < comboChange.getRevisionInfosCount(); ++i) {
            FileRevision revision = (FileRevision)comboChange.getFileRevisions().get(i);
            revMap.put(revision.getPath(), revision);
        }
        Assert.assertEquals((String)"Number of paths in combo revision incorrect", (int)1, (int)revMap.size());
        Assert.assertEquals((String)"Incorrect Path in combo revision", (Object)new Path((CharSequence)"test2.txt"), revMap.keySet().iterator().next());
    }
}

