/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import org.apache.subversion.javahl.ClientException;
import org.junit.Test;

public class MovedTagTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/movetag.dump";
    }

    @Test
    public void testTagMove() throws IOException, ClientException, DbException, ConfigException {
        FileHistory f1History = this.cache.getFileHistory(new Path((CharSequence)"/trunk/d1/f1.txt"));
        FileRevision head = f1History.getRevision(f1History.getHead());
        Assert.assertTrue((String)"Should contain tag t2", (boolean)head.getTags().contains("t2"));
        Assert.assertFalse((String)"Should not contain tag t1", (boolean)head.getTags().contains("t1"));
        FileHistory tagHistory = this.cache.getFileHistory(new Path((CharSequence)"/tags/t1"));
        List tagRevs = tagHistory.getRevisionsSorted();
        FileRevision latestRev = (FileRevision)tagRevs.get(0);
        Assert.assertTrue((String)"Tag should be marked as a deleted dir", (boolean)latestRev.isDead());
    }
}

