/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnChangeSet;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class MoveTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/moves.dump";
    }

    @Test
    public void testFileCopy() throws DbException {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)"trunk/test1.txt"), "3");
        FileRevision rev = this.cache.getFileRevision(key);
        junit.framework.Assert.assertTrue((String)"Expected this to be a copy", (boolean)rev.isCopy());
        RevInfoKey sourceKey = rev.getCopySource();
        junit.framework.Assert.assertEquals((String)"Incorrect copy source path", (Object)new Path((CharSequence)"trunk/test.txt"), (Object)sourceKey.getPath());
        junit.framework.Assert.assertEquals((String)"Incorrect copy source rev", (String)"2", (String)sourceKey.getRev());
    }

    @Test
    public void testFileMove() throws DbException {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)"trunk/test3.txt"), "5");
        FileRevision rev = this.cache.getFileRevision(key);
        junit.framework.Assert.assertTrue((String)"Expected this to be a move", (boolean)rev.isMove());
        junit.framework.Assert.assertTrue((String)"Expected this to be an add", (boolean)rev.isAdded());
        junit.framework.Assert.assertTrue((String)"Expected this to be a move not a copy", (!rev.isCopy() ? 1 : 0) != 0);
        RevInfoKey sourceKey = rev.getMoveSource();
        junit.framework.Assert.assertEquals((String)"Incorrect move source path", (Object)new Path((CharSequence)"trunk/test2.txt"), (Object)sourceKey.getPath());
        junit.framework.Assert.assertEquals((String)"Incorrect move source rev", (String)"4", (String)sourceKey.getRev());
        rev = this.cache.getFileRevision(sourceKey);
        RevInfoKey destKey = rev.getMoveDestination();
        junit.framework.Assert.assertEquals((String)"Incorrect move dest path", (Object)new Path((CharSequence)"trunk/test3.txt"), (Object)destKey.getPath());
        junit.framework.Assert.assertEquals((String)"Incorrect move dest rev", (String)"5", (String)destKey.getRev());
        FileHistory hist = this.cache.getFileHistory(new Path((CharSequence)"trunk/a-copy.zip"));
        junit.framework.Assert.assertTrue((String)"File is not indicated as binary", (boolean)hist.isBinary());
        SvnChangeSet cs = this.cache.getChangeSet("4");
        junit.framework.Assert.assertNotNull((Object)cs);
        junit.framework.Assert.assertEquals((int)1, (int)cs.getRevisionInfosCount());
        rev = (FileRevision)cs.getFileRevisions().get(0);
        junit.framework.Assert.assertEquals((String)"Incorrect revision path", (Object)new Path((CharSequence)"trunk/test2.txt"), (Object)rev.getPath());
        destKey = rev.getMoveDestination();
        junit.framework.Assert.assertEquals((String)"Incorrect move dest path", (Object)new Path((CharSequence)"trunk/test3.txt"), (Object)destKey.getPath());
        junit.framework.Assert.assertEquals((String)"Incorrect move dest rev", (String)"5", (String)destKey.getRev());
        cs = this.cache.getChangeSet("5");
        junit.framework.Assert.assertNotNull((Object)cs);
        junit.framework.Assert.assertEquals((int)2, (int)cs.getRevisionInfosCount());
        HashMap<Path, SvnRevInfo> revInfoMap = new HashMap<Path, SvnRevInfo>();
        for (SvnRevInfo revInfo : cs.getFileRevisions()) {
            revInfoMap.put(revInfo.getPath(), revInfo);
        }
        junit.framework.Assert.assertTrue((String)"Move source not in changeset", (boolean)revInfoMap.containsKey(new Path((CharSequence)"trunk/test2.txt")));
        junit.framework.Assert.assertTrue((String)"Move dest not in changeset", (boolean)revInfoMap.containsKey(new Path((CharSequence)"trunk/test3.txt")));
        rev = (FileRevision)revInfoMap.get(new Path((CharSequence)"trunk/test3.txt"));
        junit.framework.Assert.assertTrue((String)"Expected this to be a move", (boolean)rev.isMove());
        junit.framework.Assert.assertTrue((String)"Expected this to be an add", (boolean)rev.isAdded());
        junit.framework.Assert.assertTrue((String)"Expected this to be a move not a copy", (!rev.isCopy() ? 1 : 0) != 0);
        sourceKey = rev.getMoveSource();
        junit.framework.Assert.assertEquals((String)"Incorrect move source path", (Object)new Path((CharSequence)"trunk/test2.txt"), (Object)sourceKey.getPath());
        junit.framework.Assert.assertEquals((String)"Incorrect move source rev", (String)"4", (String)sourceKey.getRev());
        rev = (FileRevision)revInfoMap.get(new Path((CharSequence)"trunk/test2.txt"));
        junit.framework.Assert.assertTrue((String)"Expected move source to be deleted", (boolean)rev.isDead());
    }

    @Test
    public void testFileCopyDestinations() throws DbException {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)"trunk/test.txt"), "2");
        FileRevision rev = this.cache.getFileRevision(key);
        List copiedTo = rev.getCopyDestinations();
        HashSet copiedToSet = new HashSet();
        copiedToSet.addAll(copiedTo);
        junit.framework.Assert.assertEquals((String)"Copy destination count incorrect", (int)2, (int)copiedToSet.size());
        junit.framework.Assert.assertTrue((String)"Missing rev from copy destinations", (boolean)copiedToSet.contains(new RevInfoKey(new Path((CharSequence)"trunk/test1.txt"), "3")));
        junit.framework.Assert.assertTrue((String)"Missing rev from copy destinations", (boolean)copiedToSet.contains(new RevInfoKey(new Path((CharSequence)"trunk/test2.txt"), "4")));
        key = new RevInfoKey(new Path((CharSequence)"trunk/test3.txt"), "5");
        rev = this.cache.getFileRevision(key);
        copiedTo = rev.getCopyDestinations();
        junit.framework.Assert.assertEquals((String)"Uncopied file should not have any destinations", (int)0, (int)copiedTo.size());
    }

    @Test
    public void testFileMoveDestinations() throws DbException {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)"trunk/test2.txt"), "4");
        FileRevision rev = this.cache.getFileRevision(key);
        RevInfoKey destination = rev.getMoveDestination();
        junit.framework.Assert.assertEquals((String)"Move destination incorrect", (Object)new RevInfoKey(new Path((CharSequence)"trunk/test3.txt"), "5"), (Object)destination);
        key = new RevInfoKey(new Path((CharSequence)"trunk/test.txt"), "2");
        rev = this.cache.getFileRevision(key);
        destination = rev.getMoveDestination();
        junit.framework.Assert.assertTrue((String)"Unmoved file should not have a move destination", (destination == null ? 1 : 0) != 0);
    }

    @Test
    public void testFileMovedInsideADirectory() throws Exception {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)"trunk/dir3/testfile.txt"), "10");
        SvnRevInfo rev = (SvnRevInfo)this.cache.getFileRevision(key);
        junit.framework.Assert.assertTrue((boolean)rev.isAdded());
        Assert.assertFalse((boolean)rev.isCopy());
        junit.framework.Assert.assertTrue((boolean)rev.isMove());
        junit.framework.Assert.assertEquals((Object)new Path((CharSequence)"trunk/dir2/testfile.txt"), (Object)rev.getCopySourcePath());
        junit.framework.Assert.assertEquals((long)9L, (long)rev.getCopySourceRevision());
        junit.framework.Assert.assertEquals((Object)ImmutableList.of((Object)new Hunk(0, 1, 0, 1)), (Object)rev.getHunks());
    }
}

