/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class LinkTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/link.dump";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLinkResolution() {
        File content = null;
        FileInputStream fis = null;
        try {
            content = FisheyeTestUtil.createTempFile("content-" + this.getEngine().getName() + "-");
            FileOutputStream fos = new FileOutputStream(content);
            this.cache.getTextRevision(new RevInfoKey(new Path((CharSequence)"test3.txt"), "3"), (OutputStream)fos, null, null);
            fos.close();
            byte[] buffer = new byte[1000];
            fis = new FileInputStream(content);
            int size = fis.read(buffer);
            String data = new String(buffer, 0, size);
            Assert.assertEquals((String)"Content should be link content", (String)"link test2.txt", (String)data);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                Assert.fail();
            }
            catch (Throwable throwable) {
                IOHelper.close((Closeable[])new Closeable[]{fis});
                IOHelper.deleteFile(content);
                throw throwable;
            }
            IOHelper.close((Closeable[])new Closeable[]{fis});
            IOHelper.deleteFile((File)content);
        }
        IOHelper.close((Closeable[])new Closeable[]{fis});
        IOHelper.deleteFile((File)content);
    }

    @Test
    public void testLinkedContent() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.cache.getTextRevision(new RevInfoKey(new Path((CharSequence)"test3.txt"), "3"), (OutputStream)stream, null, null);
            String result = new String(stream.toByteArray());
            Assert.assertEquals((String)"Content should be link value", (String)"link test2.txt", (String)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testLinkedBlame() {
        try {
            Blame blame = this.cache.getBlame(new RevInfoKey(new Path((CharSequence)"test5.txt"), "5"));
            List chunks = blame.getChunks();
            Assert.assertEquals((String)"Num chunks incorrect", (int)1, (int)chunks.size());
            BlameChunk chunk = (BlameChunk)chunks.get(0);
            Assert.assertEquals((String)"Content length is incorrect (should just be link info)", (int)1, (int)chunk.getLength());
            blame = this.cache.getBlame(new RevInfoKey(new Path((CharSequence)"dir/test7.txt"), "7"));
            chunks = blame.getChunks();
            Assert.assertEquals((String)"Num chunks incorrect", (int)1, (int)chunks.size());
            chunk = (BlameChunk)chunks.get(0);
            Assert.assertEquals((String)"Content length is incorrect", (int)1, (int)chunk.getLength());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testMissingLink() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.cache.getTextRevision(new RevInfoKey(new Path((CharSequence)"dir/test7.txt"), "7"), (OutputStream)stream, null, null);
            String result = new String(stream.toByteArray());
            Assert.assertEquals((String)"Content should have been link data", (String)"link missing.txt", (String)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testLinkAbove() {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.cache.getTextRevision(new RevInfoKey(new Path((CharSequence)"dir/test6.txt"), "6"), (OutputStream)stream, null, null);
            String result = new String(stream.toByteArray());
            Assert.assertEquals((String)"Content failed to match link info", (String)"link ../test.txt", (String)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testLinkedHistory() {
        try {
            FileHistory history = this.cache.getFileHistory(new Path((CharSequence)"test5.txt"));
            FileRevision rev = history.getRevision("5");
            int lineCount = rev.getLineCount();
            Assert.assertEquals((String)"Line count incorrect", (int)1, (int)lineCount);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

