/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.util.Disposer;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class LineEndingsTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/lineEndings.dump";
    }

    @Test
    public void testLineCounts() throws Exception {
        this.assertLineCount("Mac line count mismatch", "trunk/macfile.txt", 2, 56);
        this.assertLineCount("Mac line count mismatch", "trunk/mactounix.txt", 3, 56);
        this.assertLineCount("Mac to Unix line count mismatch", "trunk/mactounix.txt", 4, 56);
        this.assertLineCount("Unix line count mismatch", "trunk/unixtomac.txt", 5, 56);
        this.assertLineCount("Unix to Mac line count mismatch", "trunk/unixtomac.txt", 6, 56);
        this.assertLineCount("PC File line count mismatch", "trunk/pcfile.txt", 7, 56);
    }

    @Test
    public void testAnnotation() throws DbException, IOException {
        this.assertIndexedReaderCount("Indexed Line Reader total for PC File incorrect", "trunk/pcfile.txt", 7, 56);
        this.assertIndexedReaderCount("Indexed Line Reader total for Mac File incorrect", "trunk/macfile.txt", 2, 56);
        this.assertIndexedReaderCount("Indexed Line Reader total for Mac File incorrect", "trunk/mactounix.txt", 3, 56);
        this.assertIndexedReaderCount("Indexed Line Reader total for MacToUnix File incorrect", "trunk/mactounix.txt", 4, 56);
        this.assertIndexedReaderCount("Indexed Line Reader total for Unix File incorrect", "trunk/unixtomac.txt", 5, 56);
        this.assertIndexedReaderCount("Indexed Line Reader total for UnixToMac File incorrect", "trunk/unixtomac.txt", 6, 56);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertIndexedReaderCount(String comment, String path, int rev, int numLines) throws DbException, IOException {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)path), Integer.toString(rev));
        FileRevision info = this.cache.getFileRevision(key);
        Disposer.pushThreadInstance();
        try {
            StreamIndexedLineReader lines = this.cache.getUnicodeTextRevision(info, "", null);
            lines.scanRestOfFile();
            Assert.assertEquals((String)comment, (int)numLines, (int)lines.getTotalLines());
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private void assertLineCount(String failMessage, String path, int rev, int expected) throws DbException {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)path), Integer.toString(rev));
        int lineCount = this.cache.getFileRevision(key).getLineCount();
        Assert.assertEquals((String)failMessage, (int)expected, (int)lineCount);
    }
}

