/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.cenqua.fisheye.util.RevisionDateRange;
import org.junit.Assert;
import org.junit.Test;

public class LastModifiedDirTimesTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/lastmodifieddir.dump";
    }

    @Test
    public void testLastModifiedDirTimes() {
        SvnRevInfo fileRev1 = this.cache.getLatestFileRevision(new Path((CharSequence)"trunk/a/b/c/d/e/f/b.txt"));
        Path trunk = new Path((CharSequence)"trunk");
        Path path = new Path((CharSequence)"trunk/a/b/c/d/e/f/");
        while (!path.equals((Object)trunk)) {
            RevisionDateRange range1 = this.cache.findDirInfo(path).getSubTreeDateRange();
            Assert.assertTrue((String)"Expecting range to be set", (boolean)range1.hasMinMax());
            Assert.assertTrue((String)"Expecting range to have rev info", (boolean)range1.hasRevisionInfo());
            junit.framework.Assert.assertEquals((String)"Expecting subdir file revision", (Object)fileRev1, (Object)this.cache.getFileRevision(range1.getMaxRevId().intValue()));
            path = path.getParent();
        }
        SvnRevInfo fileRev2 = this.cache.getLatestFileRevision(new Path((CharSequence)"trunk/a.txt"));
        RevisionDateRange range2 = this.cache.findDirInfo(trunk).getSubTreeDateRange();
        Assert.assertTrue((String)"Expecting range to be set", (boolean)range2.hasMinMax());
        Assert.assertTrue((String)"Expecting range to have rev info", (boolean)range2.hasRevisionInfo());
        junit.framework.Assert.assertEquals((String)"Expecting subdir file revision", (Object)fileRev2, (Object)this.cache.getFileRevision(range2.getMaxRevId().intValue()));
    }
}

