/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.svn.SvnTestHarness;
import junit.framework.Assert;
import org.junit.Test;

public class JSMimeTypeTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/jsmime.dump";
    }

    @Override
    protected void configureTestHarness(SvnTestHarness testHarness) {
        super.configureTestHarness(testHarness);
        testHarness.getRootConfig().getRawMimeMap().addTextMimeType("application/x-javascript");
    }

    @Test
    public void testJsBinary() {
        FileHistory trunkHistory = this.cache.getFileHistory(new Path((CharSequence)"/trunk/q2.js"));
        FileRevision head = trunkHistory.getRevision(trunkHistory.getHead());
        Assert.assertNotNull((String)"q2 head revision not found", (Object)head);
        Assert.assertTrue((String)"q2 head rev should be text", (!head.isBinary() ? 1 : 0) != 0);
        trunkHistory = this.cache.getFileHistory(new Path((CharSequence)"/trunk/qunit.js"));
        head = trunkHistory.getRevision(trunkHistory.getHead());
        Assert.assertNotNull((String)"qunit head revision not found", (Object)head);
        Assert.assertTrue((String)"qunit head rev should be text", (!head.isBinary() ? 1 : 0) != 0);
    }
}

