/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Diff;
import com.cenqua.fisheye.diff.DiffInfo;
import com.cenqua.fisheye.diff.DiffOpts;
import com.cenqua.fisheye.diff.DiffSequences;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.LineComparator;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.diff.TextFileDiffSequences;
import com.cenqua.fisheye.diff.view.FileDiffExplorer;
import com.cenqua.fisheye.io.IndexedLineReader;
import com.cenqua.fisheye.io.StreamIndexedLineReader;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.syntax.SyntaxDefinition;
import com.cenqua.fisheye.util.Disposer;
import java.io.IOException;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class IgnorableDiffTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/ignorablediff.dump";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDiffRendering() throws DbException, IOException {
        Disposer.pushThreadInstance();
        try {
            Path path = new Path((CharSequence)"trunk/test.java");
            FileRevision rev1 = this.cache.getFileRevision(new RevInfoKey(path, "2"));
            FileRevision rev2 = this.cache.getFileRevision(new RevInfoKey(path, "3"));
            StreamIndexedLineReader lineReader1 = this.cache.getUnicodeTextRevision(rev1, null, null);
            StreamIndexedLineReader lineReader2 = this.cache.getUnicodeTextRevision(rev2, null, null);
            LineComparator lc = LineComparator.fromDiffOption((DiffOpts)new DiffOpts("wbB"));
            HunkList hunks = Diff.diff((DiffSequences)new TextFileDiffSequences((IndexedLineReader)lineReader1, (IndexedLineReader)lineReader2, lc));
            lineReader1.seekLine(0);
            lineReader2.seekLine(0);
            DiffOpts opts = new DiffOpts();
            opts.setSideBySide(false);
            opts.setSoftWrap(false);
            DiffInfo dinfo = new DiffInfo(this.cache.getRepositoryName(), "somefilename", rev1.getPath().toString(), rev1.getRevision(), rev2.getPath().toString(), rev2.getRevision());
            FileDiffExplorer explorer = new FileDiffExplorer((IndexedLineReader)lineReader1, (IndexedLineReader)lineReader2, hunks, dinfo, SyntaxDefinition.PASS_THRU, opts);
            List sections = explorer.getSections();
            Assert.assertEquals((String)"Incorrect number of sections returned in diff", (int)3, (int)sections.size());
            Section section = (Section)sections.get(1);
            Assert.assertEquals((String)"Incorrect section from start", (int)11, (int)section.getFromStart());
            Assert.assertEquals((String)"Incorrect section to start", (int)11, (int)section.getToStart());
            Assert.assertEquals((String)"Incorrect section from length", (int)0, (int)section.getFromLength());
            Assert.assertEquals((String)"Incorrect section to length", (int)2, (int)section.getToLength());
        }
        finally {
            Disposer.popThreadInstance();
        }
    }
}

