/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.config1.SvnSymbolicRuleType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnTestBase;
import junit.framework.Assert;
import org.junit.Test;

public class ExcludedDirsTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/excludeddirs.dump";
    }

    @Override
    protected AllowType getAllowRules() {
        AllowType allow = AllowType.Factory.newInstance();
        allow.addNewInclude().setTree("/pcie/design/xvm/");
        allow.addNewInclude().setTree("/pcie/design/views/rtl/");
        allow.addNewInclude().setTree("/pcie/users/branches/");
        allow.addNewInclude().setTree("/pcie_verif");
        allow.addNewInclude().setTree("/pcie_design");
        allow.addNewInclude().setTree("/pciecommon");
        AllowType.Exclude exclude = allow.addNewExclude();
        exclude.setPattern("netlist_releases");
        exclude.setCasesensitive(false);
        exclude = allow.addNewExclude();
        exclude.setPattern("views/postlayout/");
        exclude.setCasesensitive(false);
        exclude = allow.addNewExclude();
        exclude.setPattern("views/prelayout/");
        exclude.setCasesensitive(false);
        return allow;
    }

    @Override
    protected SvnSymbolicType getPathMatcher() {
        SvnSymbolicType symbol = SvnSymbolicType.Factory.newInstance();
        SvnSymbolicRuleType trunk = symbol.addNewTrunk();
        trunk.setName("trunk");
        trunk.setRegex("pcie_design/trunk");
        trunk.setLogical("");
        trunk = symbol.addNewTrunk();
        trunk.setName("trunk");
        trunk.setRegex("pcie_verif/trunk");
        trunk.setLogical("");
        SvnSymbolicRuleType branch = symbol.addNewBranch();
        branch.setName("${1}");
        branch.setRegex("pcie_design/branches/([^/]+)");
        branch.setLogical("");
        branch = symbol.addNewBranch();
        branch.setName("${1}");
        branch.setRegex("pcie_design/pcie_verif/([^/]+)");
        branch.setLogical("");
        SvnSymbolicRuleType tag = symbol.addNewTag();
        tag.setName("${1}");
        tag.setRegex("pcie_design/tags/([^/]+)");
        tag.setLogical("");
        tag = symbol.addNewBranch();
        tag.setName("${1}");
        tag.setRegex("pcie_verif/tags/([^/]+)");
        tag.setLogical("");
        return symbol;
    }

    @Test
    public void testTagMismatch() throws DbException {
        Path path = new Path((CharSequence)"/pcie_design/branches/lx50t_2005.11.11_mod/views/dir1/");
        RevInfoKey key = new RevInfoKey(path, "9");
        FileRevision rev = this.cache.getFileRevision(key);
        Assert.assertNotNull((String)"Unable to find copy from mistagged dir", (Object)rev);
        rev = this.cache.getLatestFileRevision(new Path((CharSequence)"/pcie_design/tags/releases/netlist_releases/2005.11.01.integration/views/dir1/test.txt"));
        Assert.assertNull((String)"Path was found which should be excluded", (Object)rev);
        rev = this.cache.getLatestFileRevision(new Path((CharSequence)"/pcie_design/tags/releases/netlist_releases"));
        Assert.assertNull((String)"netlist_releases Path was found which should be excluded", (Object)rev);
    }
}

