/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.SvnSymbolicRuleType;
import com.cenqua.fisheye.config1.SvnSymbolicType;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.subversion.javahl.ClientException;
import org.junit.Test;

public class DupBranchTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/dupbranch.dump";
    }

    @Override
    protected SvnSymbolicType getPathMatcher() {
        SvnSymbolicType matcher = SvnSymbolicType.Factory.newInstance();
        SvnSymbolicRuleType trunk = matcher.addNewTrunk();
        trunk.setRegex("trunk(/|)");
        trunk.setName("trunk");
        trunk.setLogical("");
        SvnSymbolicRuleType branch = matcher.addNewBranch();
        branch.setRegex("branches/([^/]+)");
        branch.setName("${1}");
        branch.setLogical("");
        branch = matcher.addNewBranch();
        branch.setRegex("archive/([^/]+)");
        branch.setName("${1}");
        branch.setLogical("");
        SvnSymbolicRuleType tag = matcher.addNewTag();
        tag.setRegex("tags/([^/]+)");
        tag.setName("${1}");
        tag.setLogical("");
        return matcher;
    }

    @Test
    public void testDupBranchHandling() throws IOException, ClientException, DbException {
        FileHistory history = this.cache.getFileHistory(new Path((CharSequence)"/trunk/test.txt"));
        FileRevision[] revs = history.getRevisions().toArray(new FileRevision[0]);
        Assert.assertEquals((String)"Incorrect number of revisions", (int)3, (int)revs.length);
        Assert.assertEquals((String)"Incorrect revision 0 found", (String)revs[0].getChangeSetId(), (String)"2");
        FisheyeTestUtil.drawHistory(history);
        history = this.cache.getFileHistory(new Path((CharSequence)"/branches/br1/test.txt"));
        revs = history.getRevisions().toArray(new FileRevision[0]);
        Assert.assertEquals((String)"Incorrect number of revisions", (int)3, (int)revs.length);
        Assert.assertEquals((String)"Incorrect revision 0 found", (String)revs[0].getChangeSetId(), (String)"2");
        Assert.assertEquals((String)"Incorrect revision 1 found", (String)revs[1].getChangeSetId(), (String)"3");
        Assert.assertEquals((String)"Incorrect revision 2 found", (String)revs[2].getChangeSetId(), (String)"4");
        history = this.cache.getFileHistory(new Path((CharSequence)"/archive/br1/test.txt"));
        revs = history.getRevisions().toArray(new FileRevision[0]);
        Assert.assertEquals((String)"Incorrect number of revisions", (int)3, (int)revs.length);
        Assert.assertEquals((String)"Incorrect revision 0 found", (String)revs[0].getChangeSetId(), (String)"2");
        Assert.assertEquals((String)"Incorrect revision 1 found", (String)revs[1].getChangeSetId(), (String)"3");
        Assert.assertEquals((String)"Incorrect revision 2 found", (String)revs[2].getChangeSetId(), (String)"4");
    }
}

