/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.LineReader;
import com.cenqua.fisheye.io.ReaderLineReader;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.svn.diff.SvnDiffAdapter;
import com.cenqua.fisheye.svn.diff.SvnDiffListener;
import com.cenqua.fisheye.svn.diff.SvnDiffParser;
import com.cenqua.fisheye.svn.diff.SvnDiffParsingException;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class DiffProcessorTest {
    @Test
    public void testCRU553() throws IOException, SvnDiffParsingException {
        File testfile = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/svn/CRU553/test.diff");
        TestListener listener = this.testDiffFile(Locale.ENGLISH, testfile);
        Assert.assertEquals((String)"Line counts did not match", (long)287L, (long)listener.getCount());
    }

    @Test
    public void testFSH4507() throws IOException, SvnDiffParsingException {
        File testfile = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/svn/FSH4507/test.diff");
        TestListener listener = this.testDiffFile(Locale.ENGLISH, "ISO8859_1", testfile);
        Assert.assertEquals((String)"Line counts did not match", (long)1005L, (long)listener.getCount());
    }

    @Test
    public void testTruncation() throws IOException, SvnDiffParsingException {
        File testfile = new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/svn/diffs/truncate.diff");
        TestListener listener = this.testDiffFile(Locale.ENGLISH, testfile);
        Assert.assertEquals((String)"Line counts did not match", (long)39L, (long)listener.getCount());
    }

    private void parseDiff(Locale locale, File testfile, ReaderLineReader reader, long revision, SvnDiffListener listener) throws SvnDiffParsingException {
        SvnDiffParser parser = new SvnDiffParser(locale, new RepositoryStatus("test"));
        parser.setContext(testfile, revision);
        parser.process(reader, listener);
    }

    private void testDiffDir(Locale locale, File diffDir) throws IOException, SvnDiffParsingException {
        File[] files;
        for (File file : files = diffDir.listFiles()) {
            if (!file.isFile() || file.getName().startsWith(".")) continue;
            this.testDiffFile(locale, file);
        }
    }

    private TestListener testDiffFile(Locale locale, String encoding, File file) throws FileNotFoundException, UnsupportedEncodingException, SvnDiffParsingException {
        TestListener listener = new TestListener();
        FileInputStream fis = new FileInputStream(file);
        ReaderLineReader reader = new ReaderLineReader(LineReader.Mode.MODE_MIXED, (Reader)new InputStreamReader((InputStream)fis, encoding));
        this.parseDiff(locale, file, reader, 2L, (SvnDiffListener)listener);
        return listener;
    }

    private TestListener testDiffFile(Locale locale, File file) throws FileNotFoundException, UnsupportedEncodingException, SvnDiffParsingException {
        return this.testDiffFile(locale, "UTF-8", file);
    }

    @Test
    public void testAllCRU553Diffs() throws IOException, SvnDiffParsingException {
        this.testDiffDir(Locale.ENGLISH, new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/svn/CRU553"));
    }

    @Test
    public void testAllDiffs() throws IOException, SvnDiffParsingException {
        this.testDiffDir(Locale.ENGLISH, new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/svn/diffs"));
    }

    private static class TestListener
    extends SvnDiffAdapter {
        private int count;
        List<List<String>> appendedProperties = new ArrayList<List<String>>();
        List<List<String>> removedProperties = new ArrayList<List<String>>();
        List<List<String>> updatedProperties = new ArrayList<List<String>>();

        public void addLine(Path path, String line) {
            ++this.count;
        }

        public void removeLine(Path path, String line) {
            --this.count;
        }

        public int getCount() {
            return this.count;
        }

        public void updateProperty(Path path, String name, String value) {
            this.addValues(this.updatedProperties, path.toString(), name, value);
        }

        public void removeProperty(Path path, String name, String value) {
            this.addValues(this.removedProperties, path.toString(), name, value);
        }

        public void appendProperty(Path path, String name, String value) {
            this.addValues(this.appendedProperties, path.toString(), name, value);
        }

        private void addValues(List<List<String>> properties, String ... values) {
            properties.add(Arrays.asList(values));
        }
    }
}

