/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnTestBase;
import junit.framework.Assert;
import org.junit.Test;

public class DeletedDirTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/deldir.dump";
    }

    @Test
    public void testDeletedByMove() throws DbException {
        FileRevision rev = this.cache.getFileRevision(new RevInfoKey(new Path((CharSequence)"trunk/dir1"), "3"));
        Assert.assertNotNull((String)"Revision not found", (Object)rev);
        Assert.assertTrue((String)"revision was not deleted", (boolean)rev.isDead());
        Assert.assertEquals((String)"Incorrect filetype", (int)2, (int)rev.getFileType());
        rev = this.cache.getFileRevision(new RevInfoKey(new Path((CharSequence)"trunk/dir1/test.txt"), "3"));
        Assert.assertNotNull((String)"File rev not found", (Object)rev);
        Assert.assertTrue((String)"revision was not deleted", (boolean)rev.isDead());
        Assert.assertEquals((String)"Incorrect filetype", (int)1, (int)rev.getFileType());
        Assert.assertEquals((String)"Incorrect line count", (int)0, (int)rev.getLineCount());
        Assert.assertEquals((String)"Incorrect removed count", (int)1, (int)rev.getLinesRemoved());
    }

    @Test
    public void testDeletedByDel() throws DbException {
        FileRevision rev = this.cache.getFileRevision(new RevInfoKey(new Path((CharSequence)"trunk/dir3"), "5"));
        Assert.assertNotNull((String)"Revision not found", (Object)rev);
        Assert.assertTrue((String)"revision was not deleted", (boolean)rev.isDead());
        Assert.assertEquals((String)"Incorrect filetype", (int)2, (int)rev.getFileType());
        rev = this.cache.getFileRevision(new RevInfoKey(new Path((CharSequence)"trunk/dir3/test.txt"), "5"));
        Assert.assertNotNull((String)"File rev not found", (Object)rev);
        Assert.assertTrue((String)"revision was not deleted", (boolean)rev.isDead());
        Assert.assertEquals((String)"Incorrect filetype", (int)1, (int)rev.getFileType());
        Assert.assertEquals((String)"Incorrect line count", (int)0, (int)rev.getLineCount());
        Assert.assertEquals((String)"Incorrect removed count", (int)1, (int)rev.getLinesRemoved());
    }
}

