/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.svn.Svn2FileHistory;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnTestBase;
import junit.framework.Assert;
import org.junit.Test;

public class CopyThenModifyTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/copymodify.dump";
    }

    @Override
    protected AllowType getAllowRules() {
        AllowType allow = AllowType.Factory.newInstance();
        allow.addNewExclude().setPattern("/trunk/dir3/");
        return allow;
    }

    @Test
    public void testSlurping() throws DbException {
        Path path = new Path((CharSequence)"/trunk/dir2/test1.txt");
        Svn2FileHistory history = this.cache.getFileHistory(path, false);
        Assert.assertEquals((String)"Incorrect number of entries", (int)2, (int)history.getRevisions().size());
        FileRevision rev = this.cache.getFileRevision(new RevInfoKey(path, "4"));
        Assert.assertTrue((String)"Should be indicated as an add", (boolean)rev.isAdded());
        Assert.assertFalse((String)"Should not be indicated as a modification", (boolean)rev.isModify());
    }
}

