/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.google.common.collect.ImmutableList;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class CopyProcessingTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/copyprocessing.dump";
    }

    @Override
    protected AllowType getAllowRules() {
        AllowType allow = AllowType.Factory.newInstance();
        allow.addNewExclude().setPattern("/excluded/**");
        return allow;
    }

    @Test
    public void testCopyProcessing() throws DbException {
        this.assertLineCount("trunk/dir1/dir2/test1.txt", 2L, 1);
        this.assertLineCount("trunk/dir1/dir2/test3.txt", 3L, 1);
        this.assertLineCount("trunk/dir1/dir2/test4.txt", 4L, 2);
        this.assertLineCount("trunk/dir1/dir3/test3.txt", 5L, 1);
        this.assertLineCount("trunk/dir1/dir4/test1.txt", 6L, 2);
        this.assertLineCount("branches/b1/dir1/dir4/test1.txt", 7L, 2);
        this.assertLineCount("branches/b1/dir1/dir2/test1.txt", 7L, 1);
        this.assertLineCount("/trunk/dir1/dir2/test5.txt", 9L, 2);
        this.assertLineCount("trunk/dir1/dir5/test1.txt", 10L, 2);
        this.assertLineCount("trunk/dir1/dir6/test2.txt", 11L, 1);
        this.assertLineCount("trunk/dir1/dir6/test1.txt", 11L, 2);
        this.assertDeleted("trunk/dir1/dir6/test1.txt", 12L);
        this.assertDeleted("trunk/dir1/dir6", 12L);
        this.assertDeleted("trunk/dir1/dir6", 12L);
        this.assertDeleted("/trunk/dir1/dir5/test4.txt", 13L);
        this.assertNoRevision("trunk/dir1a/dir2", 15L);
        this.assertNoRevision("trunk/dir1a/dir5/test4.txt", 15L);
        this.assertNoRevision("trunk/dir1a/dir2/test1.txt", 15L);
        this.assertLineCount("trunk/dir1a/dir5/test1.txt", 15L, 2);
        this.assertLineCount("trunk/dir1a/dir5/test1.txt", 15L, 2);
        this.assertLineCount("/trunk/dir1/dir8/test3.txt", 16L, 1);
        this.assertLineCount("/trunk/dir1/etest1.txt", 19L, 1);
        this.assertLineCount("/tags/t1/dir1/dir2/test1.txt", 20L, 2);
        this.assertLineCount("/tags/t1/dir1/dir2/test5.txt", 21L, 1);
        this.assertDeleted("/trunk/dir1/dir8/test1.txt", 22L);
        this.assertLineCount("/trunk/dir1/dir8/test1.txt", 23L, 2);
        this.assertLineCount("trunk/fromex/dire1/etest1.txt", 24L, 2);
        this.assertProperty("trunk/fromex/dire1/etest1.txt", 25L, "svn:mime-type", "application/octet-stream");
        this.assertLineCount("trunk/fromex/dire1/etest1.txt", 25L, 0);
        this.assertNoProperty("trunk/fromex/dire1/etest1.txt", 26L, "svn:mime-type");
        this.assertLineCount("trunk/fromex/dire1/etest1.txt", 26L, 2);
        this.assertLineCount("trunk/test.txt", 27L, 1);
        this.assertLineCount("/trunk/dir1b/dir2/test4.txt", 28L, 2);
        this.assertDeleted("/trunk/dir1b/dir2/test4.txt", 29L);
        this.assertLineCount("/trunk/dir1b/dir2/test1.txt", 30L, 2);
        this.assertLineCount("/trunk/dir1b/dir2/test2.txt", 30L, 1);
        this.assertLineCount("/trunk/dir1b/dir2/test3.txt", 30L, 3);
        this.assertLineChange("/trunk/dir1b/dir2/test2.txt", 30L, 1, 0);
        this.assertLineCount("/branches/b2/dir1/dir2/test1.txt", 31L, 2);
        this.assertLineCount("/branches/b2/dir1/dir2/test2.txt", 31L, 1);
        this.assertLineCount("/branches/b2/dir1/dir2/test3.txt", 31L, 1);
        this.assertLineCount("/branches/b2/dir1b/dir2/test1.txt", 31L, 2);
        this.assertDeleted("branches/b1", 32L);
        this.assertDeleted("branches/b1/dir1/dir2/test1.txt", 32L);
        this.assertLineChange("/branches/b1/dir1/dir2/test1.txt", 32L, 0, 1);
        this.assertLineChange("/branches/b1/dir1/dir2/test2.txt", 32L, 0, 1);
        this.assertLineCount("/branches/b1/dir1/dir2/test1.txt", 33L, 2);
        this.assertLineCount("/branches/b1/dir1/dir2/test2.txt", 33L, 1);
        this.assertNoRevision("/branches/b1/dir1/dir2/test3.txt", 33L);
        this.assertLineCount("/branches/b1/dir1b/dir2/test1.txt", 33L, 2);
        this.assertDeleted("branches/b1", 34L);
        this.assertDeleted("/branches/b1/dir1/dir2/test1.txt", 34L);
        this.assertLineCount("/branches/b1/dir1/dir2/test1.txt", 35L, 2);
        this.assertLineCount("/branches/b1/dir1/dir2/test2.txt", 35L, 2);
        this.assertLineCount("/branches/b1/dir1/dir2/test3.txt", 35L, 1);
        this.assertLineCount("/trunk/dir1/dir2/test1.txt", 36L, 1);
        this.assertLineCount("/trunk/dir1/dir2/test2.txt", 36L, 3);
        this.assertDeleted("branches/b1", 37L);
        this.assertDeleted("/branches/b1/dir1/dir2/test1.txt", 37L);
        this.assertLineChange("/branches/b1/dir1/dir2/test1.txt", 37L, 0, 2);
        this.assertLineChange("/branches/b1/dir1/dir2/test2.txt", 37L, 0, 2);
        this.assertLineCount("/branches/b1/dir1/dir2/test1.txt", 38L, 1);
        this.assertLineCount("/branches/b1/dir1/dir2/test2.txt", 38L, 3);
        this.assertLineCount("/branches/b1/dir1/dir2/test3.txt", 38L, 2);
        this.assertLineChange("/branches/b1/dir1/dir2/test1.txt", 38L, 1, 0);
        this.assertLineChange("/branches/b1/dir1/dir2/test2.txt", 38L, 3, 0);
        this.assertLineChange("/branches/b1/dir1/dir2/test3.txt", 38L, 2, 0);
        this.assertLineCount("trunk/dir1/dir2/test1.txt", 39L, 5);
        this.assertDeleted("tags/t2", 40L);
        this.assertLineCount("tags/t2/dir1/dir2/test1.txt", 41L, 5);
        this.assertDeleted("trunk/dir1/dir5", 42L);
        this.assertLineCount("/trunk/dir1/dir2/test1.txt", 43L, 8);
        this.assertLineCount("/trunk/dir1/dir2/test2.txt", 43L, 2);
        this.assertLineCount("/trunk/dir1c/dir2/test1.txt", 44L, 8);
        this.assertLineCount("/trunk/dir1c/dir2/test2.txt", 44L, 2);
        this.assertLineCount("/trunk/dir1/dir2/test1.txt", 45L, 8);
        this.assertLineCount("/trunk/dir1/dir2/test1.txt", 46L, 8);
        this.assertLineCount("/trunk/dir1/dir2/test4.txt", 46L, 8);
        this.assertDeleted("trunk/dir1c", 47L);
        this.assertDeleted("tags/t1", 51L);
    }

    @Test
    public void testFileCopiedInsideADirectory() throws Exception {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)"trunk/dir1/dir3/test3.txt"), "5");
        SvnRevInfo rev = (SvnRevInfo)this.cache.getFileRevision(key);
        Assert.assertTrue((boolean)rev.isAdded());
        Assert.assertTrue((boolean)rev.isCopy());
        Assert.assertFalse((boolean)rev.isMove());
        Assert.assertEquals((Object)new Path((CharSequence)"trunk/dir1/dir2/test3.txt"), (Object)rev.getCopySourcePath());
        Assert.assertEquals((long)3L, (long)rev.getCopySourceRevision());
        Assert.assertEquals((Object)ImmutableList.of((Object)new Hunk(0, 1, 0, 1)), (Object)rev.getHunks());
    }

    private void assertLineChange(String path, long revision, int expectedAdded, int expectedRemoved) throws DbException {
        FileRevision rev = this.getRevision(path, revision);
        this.assertRevisionMatch(path, revision, rev);
        String revDescriptor = this.getDescriptor(path, revision);
        Assert.assertEquals((String)(revDescriptor + " line added count incorrect"), (int)expectedAdded, (int)rev.getLinesAdded());
        Assert.assertEquals((String)(revDescriptor + " line removed count incorrect"), (int)expectedRemoved, (int)rev.getLinesRemoved());
    }

    private void assertProperty(String path, long revision, String propName, String propValue) throws DbException {
        FileRevision rev = this.getRevision(path, revision);
        this.assertRevisionMatch(path, revision, rev);
        String revDescriptor = this.getDescriptor(path, revision);
        Assert.assertFalse((String)(revDescriptor + " expected to exist but is deleted"), (boolean)rev.isDead());
        SvnRevInfo svnRev = (SvnRevInfo)rev;
        Map props = svnRev.getProperties();
        Assert.assertTrue((String)(revDescriptor + " does not contain the " + propName + " property"), (boolean)props.containsKey(propName));
        Assert.assertEquals((String)(revDescriptor + " " + propName + " property incorrect value"), (String)propValue, (String)((String)props.get(propName)));
    }

    private void assertNoProperty(String path, long revision, String propName) throws DbException {
        FileRevision rev = this.getRevision(path, revision);
        this.assertRevisionMatch(path, revision, rev);
        String revDescriptor = this.getDescriptor(path, revision);
        Assert.assertFalse((String)(revDescriptor + " expected to exist but is deleted"), (boolean)rev.isDead());
        SvnRevInfo svnRev = (SvnRevInfo)rev;
        Map props = svnRev.getProperties();
        Assert.assertFalse((String)(revDescriptor + " contain the " + propName + " property when it should not"), (boolean)props.containsKey(propName));
    }

    private void assertNoRevision(String path, long revision) throws DbException {
        FileRevision rev = this.getRevision(path, revision);
        String revDescriptor = this.getDescriptor(path, revision);
        Assert.assertNull((String)(revDescriptor + " expected to not exist but does"), (Object)rev);
    }

    private void assertDeleted(String path, long revision) throws DbException {
        FileRevision rev = this.getRevision(path, revision);
        this.assertRevisionMatch(path, revision, rev);
        String revDescriptor = this.getDescriptor(path, revision);
        Assert.assertEquals((String)(revDescriptor + " line count of deleted incorrect"), (int)0, (int)rev.getLineCount());
        Assert.assertTrue((String)(revDescriptor + " expected to be deleted but is not"), (boolean)rev.isDead());
    }

    private void assertLineCount(String path, long revision, int expectedCount) throws DbException {
        FileRevision rev = this.getRevision(path, revision);
        this.assertRevisionMatch(path, revision, rev);
        String revDescriptor = this.getDescriptor(path, revision);
        Assert.assertTrue((String)"File should be a file", (boolean)rev.isFile());
        Assert.assertEquals((String)(revDescriptor + " line count incorrect"), (int)expectedCount, (int)rev.getLineCount());
        Assert.assertFalse((String)(revDescriptor + " expected to exist but is deleted"), (boolean)rev.isDead());
    }

    private void assertRevisionMatch(String path, long revision, FileRevision rev) {
        String revDescriptor = this.getDescriptor(path, revision);
        Assert.assertNotNull((String)(revDescriptor + " not found when expected"), (Object)rev);
        Assert.assertEquals((String)(revDescriptor + " not expected revision"), (long)revision, (long)Long.parseLong(rev.getRevision()));
    }

    private String getDescriptor(String path, long revision) {
        return "Path " + path + "@" + revision;
    }

    private FileRevision getRevision(String path, long revision) throws DbException {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)path), Long.toString(revision));
        return this.cache.getFileRevision(key);
    }
}

