/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnConstants;
import com.cenqua.fisheye.svn.SvnScmConfig;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.io.IOException;
import java.nio.charset.Charset;
import junit.framework.Assert;
import org.apache.subversion.javahl.ClientException;
import org.junit.Test;

public class CharsetTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/charsets.dump";
    }

    @Test
    public void testCharsets() throws IOException, ClientException, DbException, ConfigException {
        Assert.assertEquals((String)"charset incorrect", (Object)SvnConstants.DEFAULT_SVN_ENCODING, (Object)this.cache.getTextEncoding(new RevInfoKey(new Path((CharSequence)"test1.txt"), "1")));
        Assert.assertEquals((String)"charset incorrect", (Object)SvnConstants.DEFAULT_SVN_ENCODING, (Object)this.cache.getTextEncoding(new RevInfoKey(new Path((CharSequence)"test2.txt"), "1")));
        Assert.assertEquals((String)"charset incorrect", (Object)Charset.forName("GB18030"), (Object)this.cache.getTextEncoding(new RevInfoKey(new Path((CharSequence)"test3.txt"), "1")));
        Assert.assertEquals((String)"charset incorrect", (Object)Charset.forName("Cp1252"), (Object)this.cache.getTextEncoding(new RevInfoKey(new Path((CharSequence)"test4.txt"), "1")));
        Assert.assertEquals((String)"charset incorrect", (Object)Charset.forName("Big5"), (Object)this.cache.getTextEncoding(new RevInfoKey(new Path((CharSequence)"test5.txt"), "1")));
        SvnScmConfig svnConfig = (SvnScmConfig)this.getEngine().getCfg().getScmConfig();
        svnConfig.setDefaultCharset(Charset.forName("iso-8859-1"));
        Assert.assertEquals((String)"charset incorrect", (Object)Charset.forName("iso-8859-1"), (Object)this.cache.getTextEncoding(new RevInfoKey(new Path((CharSequence)"test1.txt"), "1")));
        Assert.assertEquals((String)"charset incorrect", (Object)Charset.forName("iso-8859-1"), (Object)this.cache.getTextEncoding(new RevInfoKey(new Path((CharSequence)"test2.txt"), "1")));
        Assert.assertEquals((String)"charset incorrect", (Object)Charset.forName("GB18030"), (Object)this.cache.getTextEncoding(new RevInfoKey(new Path((CharSequence)"test3.txt"), "1")));
        Assert.assertEquals((String)"charset incorrect", (Object)Charset.forName("Cp1252"), (Object)this.cache.getTextEncoding(new RevInfoKey(new Path((CharSequence)"test4.txt"), "1")));
        Assert.assertEquals((String)"charset incorrect", (Object)Charset.forName("Big5"), (Object)this.cache.getTextEncoding(new RevInfoKey(new Path((CharSequence)"test5.txt"), "1")));
    }
}

