/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.svn.SvnTestHarness;
import org.junit.Assert;
import org.junit.Test;

public class CharsetChangeTest
extends SvnTestBase {
    public static final Path ASCII_FILE = new Path((CharSequence)"trunk/ascii.txt");
    public static final Path ENCODINGCHANGE_FILE = new Path((CharSequence)"trunk/encodingchange.txt");
    public static final Path ENCODEDCONTENTCHANGE_FILE = new Path((CharSequence)"trunk/encodedcontentchange.txt");
    public static final Path ENCODINGANDCONTENTCHANGE_FILE = new Path((CharSequence)"trunk/encodingandcontentchange.txt");
    public static final Path CORRECTEDENCODING_FILE = new Path((CharSequence)"trunk/correctedencoding.txt");

    @Override
    protected String getDumpFile() {
        return "charsetchange";
    }

    @Override
    protected void configureTestHarness(SvnTestHarness testHarness) {
        super.configureTestHarness(testHarness);
        testHarness.setCharset("US-ASCII");
    }

    @Test
    public void testIndexedAll() throws Exception {
        this.assertLineCounts(ASCII_FILE, "2", 1, 1, 0);
        this.assertTextLineCounts(ENCODINGCHANGE_FILE, "3", 1, 1, 0);
        this.assertTextLineCounts(ENCODINGCHANGE_FILE, "4", 1, 0, 0);
        this.assertTextLineCounts(ENCODEDCONTENTCHANGE_FILE, "5", 2, 2, 0);
        this.assertTextLineCounts(ENCODEDCONTENTCHANGE_FILE, "6", 3, 1, 0);
        this.assertTextLineCounts(ENCODINGANDCONTENTCHANGE_FILE, "7", 1, 1, 0);
        this.assertTextLineCounts(ENCODINGANDCONTENTCHANGE_FILE, "8", 2, 1, 0);
        this.assertTextLineCounts(CORRECTEDENCODING_FILE, "10", 1, 1, 0);
        this.assertTextLineCounts(CORRECTEDENCODING_FILE, "11", 1, 1, 1);
    }

    private FileRevision assertTextLineCounts(Path path, String revision, int total, int added, int removed) {
        FileRevision rev = this.assertLineCounts(path, revision, total, added, removed);
        Assert.assertFalse((String)"Text file indicated as binary", (boolean)rev.isBinary());
        return rev;
    }

    private FileRevision assertLineCounts(Path path, String revision, int total, int added, int removed) {
        FileRevision rev = this.cache.findFileRevision(path, revision);
        Assert.assertEquals((String)("Total Line Count for " + path + "@" + revision + " is incorrect"), (long)total, (long)rev.getLineCount());
        Assert.assertEquals((String)("Added Line Count for " + path + "@" + revision + " is incorrect"), (long)added, (long)rev.getLinesAdded());
        Assert.assertEquals((String)("Removed Line Count for " + path + "@" + revision + " is incorrect"), (long)removed, (long)rev.getLinesRemoved());
        return rev;
    }
}

