/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnTestBase;
import junit.framework.Assert;
import org.junit.Test;

public class CRU1060SvnTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/CRU1060.dump";
    }

    @Test
    public void testBeforeAfterAndTagging() throws Exception {
        FileRevision r172 = this.getRevision("172", null);
        FileRevision r23 = this.getRevision("23", null);
        FileRevision r162 = this.getRevision("162", "br-6168");
        FileRevision r2 = this.getRevision("2", null);
        FileRevision r21 = this.getRevision("21", "unlabeled-1.2.2");
        this.assertBefore(r2, r172, true);
        this.assertBefore(r2, r23, true);
        this.assertBefore(r2, r2, false);
        this.assertBefore(r172, r2, false);
        this.assertBefore(r23, r2, false);
        this.assertAfter(r172, r2, true);
        this.assertAfter(r172, r23, true);
        this.assertAfter(r172, r172, false);
        this.assertAfter(r2, r172, false);
        this.assertAfter(r23, r172, false);
        this.assertBefore(r2, r162, true);
        this.assertAfter(r162, r23, true);
        this.assertBefore(r2, r21, true);
        this.assertAfter(r21, r2, true);
        this.assertBefore(r23, r162, true);
        this.assertAfter(r162, r23, true);
        this.assertBefore(r162, r21, false);
        this.assertBefore(r21, r162, false);
        this.assertAfter(r162, r21, false);
        this.assertAfter(r21, r162, false);
        this.assertQueryContains(new int[]{18, 19, 20, 2}, "tagged < merge_point_VOUCHERS_TO_MAIN");
        this.assertQueryContains(new int[]{18, 19, 20, 21, 2}, "tagged <= merge_point_VOUCHERS_TO_MAIN");
        this.assertQueryContains(new int[]{2, 23, 164}, "tagged < build-MAIN-637");
        this.assertQueryContains(new int[]{23, 164, 172, 21, 20, 19, 18, 162, 39, 25, 26, 27, 30, 31, 32, 34, 37}, "tagged > build-MAIN-516");
    }

    private void assertQueryContains(int[] changeSetIds, String where) throws Exception {
        String ql = "select revisions where path like CreditCardDisplayFormat.java and " + where;
        this.assertContainsRevs(ql, changeSetIds.length, changeSetIds);
    }

    private void assertBefore(FileRevision a, FileRevision b, boolean expected) throws Exception {
        Assert.assertEquals((boolean)expected, (boolean)this.cache.isBefore(a.getRevID(), b.getRevID()));
    }

    private void assertAfter(FileRevision a, FileRevision b, boolean expected) throws Exception {
        Assert.assertEquals((boolean)expected, (boolean)this.cache.isAfter(a.getRevID(), b.getRevID()));
    }

    private FileRevision getRevision(String rev, String br) throws DbException {
        String p = br != null ? "branches/" + br : "trunk";
        p = p + "/CreditCardDisplayFormat.java";
        FileRevision ri = this.cache.getFileRevision(new RevInfoKey(new Path((CharSequence)p), rev));
        Assert.assertNotNull((Object)ri);
        return ri;
    }
}

