/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.BlameInfo;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class BlameTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/blame.dump";
    }

    @Test
    public void testMoveBlame() throws DbException, IOException {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)"trunk/test2.txt"), "4");
        Blame blame = this.cache.getBlame(key);
        List chunks = blame.getChunks();
        HashSet<Path> fileRevisions = new HashSet<Path>();
        for (BlameChunk chunk : chunks) {
            BlameInfo revision = chunk.getInfo();
            Assert.assertTrue((String)"Date was null", (revision.getDate() > 0L ? 1 : 0) != 0);
            fileRevisions.add(revision.getPath());
        }
        Assert.assertTrue((String)"blame did not point to original file location", (boolean)fileRevisions.contains(new Path((CharSequence)"trunk/test.txt")));
    }

    @Test
    public void testSize() throws Exception {
        Blame blame = new Blame((List)ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 0, 5, 2)));
        Assert.assertEquals((int)15, (int)blame.getTotalLines());
    }

    @Test
    public void testSizeEmpty() throws Exception {
        Blame emptyBlame = new Blame();
        Assert.assertEquals((int)0, (int)emptyBlame.getTotalLines());
    }
}

