/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.BlameInfo;
import com.google.common.base.Objects;
import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsAnything;

public class BlameChunkMatcher
extends TypeSafeMatcher<BlameChunk> {
    private final int start;
    private final int end;
    private Matcher<String> revision = new IsAnything();
    private Matcher<String> author = new IsAnything();
    private Matcher<Integer> revId = new IsAnything();
    private Matcher<BlameInfo> blameInfo = new IsAnything();

    public BlameChunkMatcher(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public BlameChunkMatcher withAuthor(String author) {
        this.author = Matchers.equalTo((Object)author);
        return this;
    }

    public BlameChunkMatcher withRevision(String revision) {
        this.revision = Matchers.equalTo((Object)revision);
        return this;
    }

    public BlameChunkMatcher withRevId(int revId) {
        this.revId = Matchers.equalTo((Object)revId);
        return this;
    }

    public BlameChunkMatcher withRevId(Matcher<Integer> revIdMatcher) {
        this.revId = revIdMatcher;
        return this;
    }

    public BlameChunkMatcher withBlameInfo(BlameInfo blameInfo) {
        this.blameInfo = Matchers.equalTo((Object)blameInfo);
        return this;
    }

    protected boolean matchesSafely(BlameChunk chunk) {
        return Objects.equal((Object)chunk.getStart(), (Object)this.start) && Objects.equal((Object)(chunk.getStart() + chunk.getLength()), (Object)this.end) && this.revision.matches((Object)chunk.getRevision()) && this.author.matches(Optional.ofNullable(chunk.getInfo()).map(BlameInfo::getAuthor).orElse(null)) && this.revId.matches((Object)chunk.getRevId()) && this.blameInfo.matches((Object)chunk.getInfo());
    }

    public void describeTo(Description description) {
        description.appendText("BlameChunk{").appendValue((Object)this.start).appendText("-").appendValue((Object)this.end);
        this.describeFieldMatcher(description, "revision", this.revision);
        this.describeFieldMatcher(description, "author", this.author);
        this.describeFieldMatcher(description, "revId", this.revId);
        this.describeFieldMatcher(description, "blameInfo", this.blameInfo);
        description.appendText("}");
    }

    private void describeFieldMatcher(Description description, String fieldName, Matcher<?> matcher) {
        if (!(matcher instanceof IsAnything)) {
            description.appendText(", ");
            description.appendText(fieldName);
            description.appendText(" ");
            matcher.describeTo(description);
        }
    }
}

