/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.rep.RevCountChecker;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.lucene.BranchIndexingChecker;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.subversion.javahl.ClientException;
import org.junit.Assert;
import org.junit.Test;

public class BasicSlurpTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/basic.dump";
    }

    @Test
    public void testHistoryAggregation() throws IOException, ClientException, DbException, ConfigException {
        FileHistory trunkHistory = this.cache.getFileHistory(new Path((CharSequence)"/trunk/test.txt"));
        FileRevision[] revs = trunkHistory.getRevisions().toArray(new FileRevision[0]);
        Assert.assertEquals((String)"Incorrect number of revisions", (long)7L, (long)revs.length);
        junit.framework.Assert.assertEquals((String)"Incorrect revision 0 found", (String)revs[0].getChangeSetId(), (String)"2");
        junit.framework.Assert.assertEquals((String)"Incorrect revision 1 found", (String)revs[1].getChangeSetId(), (String)"3");
        junit.framework.Assert.assertEquals((String)"Incorrect revision 2 found", (String)revs[2].getChangeSetId(), (String)"4");
        junit.framework.Assert.assertEquals((String)"Incorrect revision 3 found", (String)revs[3].getChangeSetId(), (String)"5");
        junit.framework.Assert.assertEquals((String)"Incorrect revision 4 found", (String)revs[4].getChangeSetId(), (String)"6");
        junit.framework.Assert.assertEquals((String)"Incorrect revision 5 found", (String)revs[5].getChangeSetId(), (String)"7");
        junit.framework.Assert.assertEquals((String)"Incorrect revision 6 found", (String)revs[6].getChangeSetId(), (String)"8");
        junit.framework.Assert.assertEquals((String)"Author incorrect", (String)revs[0].getAuthor(), (String)"conor");
        FileHistory branchHistory = this.cache.getFullFileHistory(new Path((CharSequence)"/branches/br1/test.txt"), true);
        Collection revisions = branchHistory.getRevisions();
        revs = revisions.toArray(new FileRevision[revisions.size()]);
        junit.framework.Assert.assertEquals((String)"Incorrect number of branch revisions", (int)4, (int)revs.length);
        junit.framework.Assert.assertEquals((String)"Incorrect branch revision 0 found", (String)revs[0].getChangeSetId(), (String)"2");
        junit.framework.Assert.assertEquals((String)"Incorrect branch revision 1 found", (String)revs[1].getChangeSetId(), (String)"3");
        junit.framework.Assert.assertEquals((String)"Incorrect branch revision 2 found", (String)revs[2].getChangeSetId(), (String)"4");
        junit.framework.Assert.assertEquals((String)"Incorrect branch revision 2 found", (String)revs[3].getChangeSetId(), (String)"7");
    }

    @Test
    public void testListDirs() throws DbException {
        Path[] paths = this.cache.listDirs(Path.ROOT);
        HashSet resultSet = Sets.newHashSet();
        for (Path path : paths) {
            resultSet.add(path.getPath());
        }
        junit.framework.Assert.assertTrue((String)"trunk dir was missing", (boolean)resultSet.contains("trunk"));
        junit.framework.Assert.assertTrue((String)"branches dir was missing", (boolean)resultSet.contains("branches"));
        junit.framework.Assert.assertTrue((String)"tags dir was missing", (boolean)resultSet.contains("tags"));
    }

    @Test
    public void testListFiles() throws DbException {
        Path[] paths = this.cache.listFiles(Path.ROOT);
        junit.framework.Assert.assertTrue((String)"Found files in root - not expected", (paths.length == 0 ? 1 : 0) != 0);
        paths = this.cache.listFiles(new Path((CharSequence)"/trunk"));
        junit.framework.Assert.assertEquals((String)"Incorrect number of files in trunk", (int)1, (int)paths.length);
        junit.framework.Assert.assertEquals((String)"File was not as expected", (Object)new Path((CharSequence)"/trunk/test.txt"), (Object)paths[0]);
    }

    @Test
    public void testBranchIndexing() {
        BranchIndexingChecker.verifyIndexedBranchesWithRevCache(this.cache);
    }

    @Test
    public void testRevCounts() {
        RevCountChecker.checkRevCounts(this.cache);
    }
}

