/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.bucket.BreakdownOption;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.bucket.ParameterSetQuery;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.util.TimeZone;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AuthBlameTest
extends SvnTestBase {
    private final TimeZone tzOrig = TimeZone.getDefault();
    private TimeZone tzOrigConfig = TimeZone.getDefault();

    @Override
    @Before
    public void setUp() throws Exception {
        TimeZone.setDefault(TimeZone.getTimeZone("Australia/Perth"));
        if (AppConfig.getsConfig() != null) {
            this.tzOrigConfig = AppConfig.getsConfig().getTimezone();
            if (AppConfig.getsConfig() != null && AppConfig.getsConfig().getConfigDocument() != null) {
                AppConfig.getsConfig().getConfig().setTimezone("Australia/Sydney");
                AppConfig.getsConfig().reload();
            }
        }
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        TimeZone.setDefault(this.tzOrig);
        if (AppConfig.getsConfig() != null && AppConfig.getsConfig().getConfigDocument() != null) {
            AppConfig.getsConfig().getConfig().setTimezone(this.tzOrigConfig.getID());
            AppConfig.getsConfig().reload();
        }
        super.tearDown();
    }

    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/authbasic.dump";
    }

    @Test
    public void testBlame() throws DbException {
        this.runTestBlame();
        this.getEngine().getBucketGraph().reindex(this.getEngine().getLinecountCalculator(), this.getEngine().getStatus());
        this.runTestBlame();
    }

    public void runTestBlame() throws DbException {
        BucketGraph bucketGraph = this.getEngine().getBucketGraph();
        ParameterSetQuery params = new ParameterSetQuery();
        params.setBranch("br1");
        Assert.assertEquals((String)"{br1={0={12992=[2(+2),1(+1)], 12993=[3(+1),2(+1)], 12996=[4(+1),3(+1)]}}}", (String)bucketGraph.getBuckets(params).toString());
        params.setPath(new Path((CharSequence)"branches"));
        Assert.assertEquals((String)"{br1={0={12992=[2(+2),1(+1)], 12993=[3(+1),2(+1)], 12996=[4(+1),3(+1)]}}}", (String)bucketGraph.getBuckets(params).toString());
        params.setPath(new Path((CharSequence)"branches/br1"));
        Assert.assertEquals((String)"{br1={0={12992=[2(+2),1(+1)], 12993=[3(+1),2(+1)], 12996=[4(+1),3(+1)]}}}", (String)bucketGraph.getBuckets(params).toString());
        params.setPath(new Path((CharSequence)"branches/br2"));
        Assert.assertEquals((String)"{}", (String)bucketGraph.getBuckets(params).toString());
        params.setPath(new Path((CharSequence)"trunk"));
        Assert.assertEquals((String)"{}", (String)bucketGraph.getBuckets(params).toString());
        params.setPath(new Path((CharSequence)""));
        params.setBreakdown(BreakdownOption.AUTHOR);
        params.setBranch(null);
        Assert.assertEquals((String)"{__ALL_AUTHORS__={0={12991=[2(+2),1(+1)], 12995=[3(+1),2(+1)], 12997=[4(+1),3(+1)]}}, b={0={12991=[2(+2),1(+1)]}}, f={0={12995=[1(+1),1(+1)]}}, h={0={12997=[1(+1),1(+1)]}}}", (String)bucketGraph.getBuckets(params).toString());
        params.setBranch("br1");
        Assert.assertEquals((String)"{__ALL_AUTHORS__={0={12992=[2(+2),1(+1)], 12993=[3(+1),2(+1)], 12996=[4(+1),3(+1)]}}, b={0={12992=[2(+2),0(+0)]}}, c={0={12992=[0(+0),1(+1)]}}, d={0={12993=[1(+1),1(+1)]}}, g={0={12996=[1(+1),1(+1)]}}}", (String)bucketGraph.getBuckets(params).toString());
        params.setBranch("br2");
        Assert.assertEquals((String)"{__ALL_AUTHORS__={0={12994=[3(+3),1(+1)]}}, e={0={12994=[3(+3),1(+1)]}}}", (String)bucketGraph.getBuckets(params).toString());
        System.out.println(bucketGraph.toStringFull());
    }
}

