/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.atlassian.fisheye.SpringIntegrationTestBase;
import com.atlassian.fisheye.svn.Svn2Cache;
import com.atlassian.fisheye.svn.Svn2Scanner;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config1.AllowType;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.svn.SvnTestHarness;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import junit.framework.Assert;
import org.apache.xmlbeans.XmlException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class AllowTest
extends SpringIntegrationTestBase {
    private SvnTestHarness testHarness;

    @Before
    public void setUp() throws Exception {
        this.testHarness = new SvnTestHarness();
    }

    @After
    public void tearDown() throws Exception {
        this.testHarness.cleanUp();
    }

    @Test
    public void testAllowed() throws DbException, IOException, RepositoryClientException, ConfigException, XmlException {
        String dumpFile = this.dumpFile();
        File basicDump = new File(FisheyeTestEnv.WORKSPACE_DIR, dumpFile);
        AllowType allow = AllowType.Factory.newInstance();
        allow.addNewInclude().setTree("project1");
        this.testHarness.setAllow(allow);
        this.testHarness.slurpDump(basicDump);
        this.testHarness.assertNoSlurpErrors(dumpFile);
        Path[] rootDirs = ((Svn2Cache)((Svn2Scanner)this.testHarness.getScanner()).getCache()).listDirs(Path.ROOT);
        Assert.assertEquals((String)"Incorrect # root dirs scanned", (int)1, (int)rootDirs.length);
        Assert.assertEquals((String)"Incorrect dir scanned", (Object)new Path((CharSequence)"project1"), (Object)rootDirs[0]);
    }

    @Test
    public void testExcludedDir() throws DbException, IOException, RepositoryClientException, ConfigException, XmlException {
        String dumpFile = this.dumpFile();
        File basicDump = new File(FisheyeTestEnv.WORKSPACE_DIR, dumpFile);
        AllowType allow = AllowType.Factory.newInstance();
        allow.addNewExclude().setPattern("project1");
        this.testHarness.setAllow(allow);
        this.testHarness.slurpDump(basicDump);
        this.testHarness.assertNoSlurpErrors(dumpFile);
        Path[] rootDirs = ((Svn2Cache)((Svn2Scanner)this.testHarness.getScanner()).getCache()).listDirs(Path.ROOT);
        Assert.assertEquals((String)"Too many root dirs scanned", (int)1, (int)rootDirs.length);
        Assert.assertEquals((String)"Incorrect dir scanned", (Object)new Path((CharSequence)"project2"), (Object)rootDirs[0]);
    }

    @Test
    public void testExcludedFiles() throws DbException, IOException, RepositoryClientException, ConfigException, XmlException {
        File basicDump = new File(FisheyeTestEnv.WORKSPACE_DIR, this.dumpFile());
        AllowType allow = AllowType.Factory.newInstance();
        allow.addNewExclude().setPattern("**/*.txt");
        this.testHarness.setAllow(allow);
        this.testHarness.slurpDump(basicDump);
        this.testHarness.assertNoSlurpErrors(this.dumpFile());
        Svn2Cache cache = (Svn2Cache)((Svn2Scanner)this.testHarness.getScanner()).getCache();
        Path[] rootDirs = cache.listDirs(Path.ROOT);
        Assert.assertEquals((String)"Too many root dirs scanned", (int)2, (int)rootDirs.length);
        HashSet paths = new HashSet();
        Collections.addAll(paths, rootDirs);
        Assert.assertTrue((String)"project1 missing", (boolean)paths.contains(new Path((CharSequence)"project1")));
        Assert.assertTrue((String)"project2 missing", (boolean)paths.contains(new Path((CharSequence)"project2")));
        Assert.assertTrue((String)"unexpected files", (cache.listFiles(new Path((CharSequence)"project1/trunk")).length == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"unexpected files", (cache.listFiles(new Path((CharSequence)"project2/trunk")).length == 0 ? 1 : 0) != 0);
    }

    private String dumpFile() {
        return "test/testfiles/svn/dumps/allow.dump";
    }

    @Test
    public void testNoExcludedFiles() throws DbException, IOException, RepositoryClientException, ConfigException, XmlException {
        File basicDump = new File(FisheyeTestEnv.WORKSPACE_DIR, this.dumpFile());
        AllowType allow = AllowType.Factory.newInstance();
        this.testHarness.setAllow(allow);
        this.testHarness.slurpDump(basicDump);
        this.testHarness.assertNoSlurpErrors(this.dumpFile());
        Svn2Cache cache = (Svn2Cache)((Svn2Scanner)this.testHarness.getScanner()).getCache();
        Path[] rootDirs = cache.listDirs(Path.ROOT);
        Assert.assertEquals((String)"Too many root dirs scanned", (int)2, (int)rootDirs.length);
        HashSet<Path> paths = new HashSet<Path>();
        for (Path dir : rootDirs) {
            paths.add(dir);
        }
        Assert.assertTrue((String)"project1 missing", (boolean)paths.contains(new Path((CharSequence)"project1")));
        Assert.assertTrue((String)"project2 missing", (boolean)paths.contains(new Path((CharSequence)"project2")));
        Assert.assertTrue((String)"unexpected files", (cache.listFiles(new Path((CharSequence)"project1/trunk")).length == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"unexpected files", (cache.listFiles(new Path((CharSequence)"project2/trunk")).length == 1 ? 1 : 0) != 0);
    }
}

