/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.svn.SvnTestBase;
import org.junit.Test;

public class AdvancedSearchTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/advsearch.dump";
    }

    @Test
    public void testHeadInBranch() throws Exception {
        this.assertContainsRevs("select revisions from dir / where path like \"**/test1.txt\" and is head", -1, new int[]{8, 4});
    }

    @Test
    public void testHeadInBranchOnBranch() throws Exception {
        this.assertContainsRevs("select revisions from dir / where path like \"**/test1.txt\" and is head on br1", 1, new int[]{4});
    }

    @Test
    public void testHeadInBranchOnTrunk() throws Exception {
        this.assertContainsRevs("select revisions from dir / where path like \"**/test1.txt\" and is head on trunk", 1, new int[]{8});
    }

    @Test
    public void testOnBranch() throws Exception {
        this.assertContainsRevs("select revisions from dir / where path like \"**/test1.txt\" and on branch br1", 2, new int[]{3, 4});
    }

    @Test
    public void testAddedOnBranch() throws Exception {
        this.assertContainsRevs("select revisions from dir / where added on branch br1", 1, new int[]{7});
    }

    @Test
    public void testDeletedOnBranch() throws Exception {
        this.assertContainsRevs("select revisions from dir / where deleted on branch br2", 2, new int[]{10, 11});
    }

    @Test
    public void testModifiedOnBranch() throws Exception {
        this.assertContainsRevs("select revisions from dir / where modified on branch br1", 2, new int[]{4, 7});
    }

    @Test
    public void testTagging() throws Exception {
        this.assertContainsRevs("select revisions from dir / where path like \"**/test4.txt\" and tagged < tagtest1", 0, null);
        this.assertContainsRevs("select revisions from dir / where path like \"**/test4.txt\" and tagged < tagtest2", 1, new int[]{13});
        this.assertContainsRevs("select revisions from dir / where path like \"**/test4.txt\" and tagged < tagtest3", 2, new int[]{13, 15});
        this.assertContainsRevs("select revisions from dir / where path like \"**/test4.txt\" and tagged < tagtest4", 3, new int[]{13, 15, 17});
        this.assertContainsRevs("select revisions from dir / where path like \"**/test4.txt\" and tagged <= tagtest4", 4, new int[]{13, 15, 17, 19});
        this.assertContainsRevs("select revisions from dir / where path like \"**/test4.txt\" and tagged < tagtest4 and tagged > tagtest2", 1, new int[]{17});
        this.assertContainsRevs("select revisions from dir / where path like \"**/test4.txt\" and tagged = tagtest4", 1, new int[]{19});
        this.assertContainsRevs("select revisions from dir / where path like \"trunk/**/test4.txt\" and tagged != tagtest2", 3, new int[]{13, 17, 19});
        this.assertContainsRevs("select revisions from dir / where path like \"**/test4.txt\" and tagged >= tagtest2", 3, new int[]{15, 17, 19});
    }
}

