/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.svn.SvnTestBase;
import com.cenqua.fisheye.svn.SvnTestHarness;
import com.cenqua.fisheye.svn.db.SvnRevInfo;
import com.google.common.base.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.SystemUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class AddedFilePropsRepoUrlCaseInsensitivityWindowsTest {
    private static final Pattern DRIVE_LETTER_PATTERN = Pattern.compile("[a-zA-Z]:");

    @BeforeClass
    public static void beforeClass() {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_WINDOWS);
    }

    @Test
    public void shouldGetAddedFilePropsWhenRepoUrlHasUppercaseDriveLetterOnWindows() throws Exception {
        this.runTest((Function<String, String>)((Function)path -> {
            Matcher m = DRIVE_LETTER_PATTERN.matcher((CharSequence)path);
            m.find();
            return m.replaceFirst(m.group(0).toUpperCase());
        }));
    }

    @Test
    public void shouldGetAddedFilePropsWhenRepoUrlHasLowercaseDriveLetterOnWindows() throws Exception {
        this.runTest((Function<String, String>)((Function)path -> {
            Matcher m = DRIVE_LETTER_PATTERN.matcher((CharSequence)path);
            m.find();
            return m.replaceFirst(m.group(0).toLowerCase());
        }));
    }

    @Test
    public void shouldGetAddedFilePropsWhenRepoUrlIsEntirelyInUppercaseOnWindows() throws Exception {
        this.runTest((Function<String, String>)((Function)path -> path.toUpperCase()));
    }

    @Test
    public void shouldGetAddedFilePropsWhenRepoUrlIsEntirelyInLowercaseOnWindows() throws Exception {
        this.runTest((Function<String, String>)((Function)path -> path.toLowerCase()));
    }

    @Test
    public void shouldGetAddedFilePropsWhenAdditionalSlashPrependsThePathOnWindows() throws Exception {
        this.runTest((Function<String, String>)((Function)path -> path.replace("file://", "file:///")));
    }

    private void runTest(Function<String, String> urlTransformer) throws Exception {
        SvnTestBase testBase = this.createTestBase(urlTransformer);
        testBase.setUp();
        this.assertAddedFileIsBinary(testBase);
        testBase.tearDown();
    }

    private void assertAddedFileIsBinary(SvnTestBase testBase) {
        FileHistory history = testBase.getCache().getFileHistory(new Path((CharSequence)"trunk/1.txt"));
        SvnRevInfo rev = (SvnRevInfo)history.getRevision("2");
        Assert.assertTrue((boolean)rev.isBinary());
    }

    private SvnTestBase createTestBase(final Function<String, String> urlTransformer) {
        return new SvnTestBase(){

            @Override
            protected String getDumpFile() {
                return "test/testfiles/svn/dumps/addedfileprops-windows.dump";
            }

            @Override
            protected SvnTestHarness createHarness() {
                return new SvnTestHarness(){

                    @Override
                    protected String getRepoURL() {
                        return "file://" + (String)urlTransformer.apply((Object)super.getRepoDir().getAbsolutePath().replace('\\', '/'));
                    }
                };
            }
        };
    }
}

