/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.svn;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileHistory;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.svn.SvnTestBase;
import java.io.IOException;
import junit.framework.Assert;
import org.apache.subversion.javahl.ClientException;
import org.junit.Test;

public class AddBackTest
extends SvnTestBase {
    @Override
    protected String getDumpFile() {
        return "test/testfiles/svn/dumps/addback.dump";
    }

    @Test
    public void testAddBack() throws IOException, ClientException, DbException, ConfigException {
        Assert.assertEquals((int)2, (int)this.getFileRevision("/trunk/test.txt", 2L).getLineCount());
        Assert.assertEquals((int)2, (int)this.getFileRevision("/branches/br1/test.txt", 3L).getLineCount());
        Assert.assertEquals((int)3, (int)this.getFileRevision("/branches/br1/test.txt", 4L).getLineCount());
        Assert.assertEquals((int)3, (int)this.getFileRevision("/branches/br2/test.txt", 5L).getLineCount());
        Assert.assertEquals((int)3, (int)this.getFileRevision("/trunk/test.txt", 6L).getLineCount());
        Assert.assertEquals((int)4, (int)this.getFileRevision("/branches/br1/test.txt", 7L).getLineCount());
        Assert.assertEquals((int)4, (int)this.getFileRevision("/trunk/test.txt", 8L).getLineCount());
        Assert.assertEquals((int)0, (int)this.getFileRevision("/trunk/test.txt", 9L).getLineCount());
        Assert.assertEquals((int)4, (int)this.getFileRevision("/trunk/test.txt", 10L).getLineCount());
        FileHistory trunkHistory = this.cache.getFileHistory(new Path((CharSequence)"/trunk/test.txt"));
        FileRevision head = trunkHistory.getRevision(trunkHistory.getHead());
        Assert.assertNotNull((String)"Head revision not found", (Object)head);
        Assert.assertEquals((String)"Head change set id incorrect", (String)"10", (String)head.getChangeSetId());
        Assert.assertEquals((String)"Addback line count not correct", (int)4, (int)head.getLineCount());
        Assert.assertEquals((String)"Addback lines added not correct", (int)4, (int)head.getLinesAdded());
    }
}

