/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.query;

import antlr.TokenStream;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.search.query.QueryLangLexer;
import com.cenqua.fisheye.search.query.QueryLangParser;
import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;

public class QueryParserTest
extends TestCase {
    public void testSimpleParsing() throws Exception {
        QueryParserTest.assertParses("select revisions where path like 'build.xml'");
        QueryParserTest.assertParses("select revisions where path like \"build.xml\"");
        QueryParserTest.assertParses("select revisions where path like build.xml");
        QueryParserTest.assertParses("select revisions where path like **/foo/**/*build?.xml");
        QueryParserTest.assertParses("select revisions where csid = 5456");
        QueryParserTest.assertParses("select revisions where csid = '5456'");
        QueryParserTest.assertParses("select revisions where csid = foo:main:20011109");
        QueryParserTest.assertParses("select revisions where csid = \"foo:main:20011109\"");
    }

    public void testKeywordsAsWords() throws Exception {
        QueryParserTest.assertParses("select revisions where author='foo' return path");
        QueryParserTest.assertParses("select revisions where author='foo' return path as bar");
        QueryParserTest.assertParses("select revisions where author='foo' return path as 'bar'");
        FishQuery q = QueryParserTest.assertParses("select revisions where author='foo' return path as 'from'");
        QueryParserTest.assertEquals((String)"from", (String)q.getReturnClause().getField(0).getColumnName());
        QueryParserTest.assertEquals((String)"path", (String)q.getReturnClause().getField(0).getField());
    }

    private static FishQuery assertParses(String str) throws Exception {
        QueryLangLexer lex = new QueryLangLexer((Reader)new StringReader(str));
        QueryLangParser parser = new QueryLangParser((TokenStream)lex);
        FishQuery query = parser.query();
        QueryParserTest.assertEquals((char)'\uffff', (char)lex.LA(1));
        return query;
    }
}

