/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.search.query;

import com.atlassian.fisheye.util.MockTestFileRevision;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.crucible.util.DummyReviewManager;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.search.aggregation.ReturnClauseAggregator;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.search.query.ReturnClause;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

public class FishQueryTest
extends TestCase {
    private static String[][] EXAMPLE_AGGREGATE_QUERIES = new String[][]{{"select revisions where path like a.txt group by dir", "count(revisions), max(linesAdded)"}, {"select revisions where date in [2008-10-10, 2008-12-12]", "count(revisions)"}, {"select revisions where date in [2008-10-10, 2008-12-12]", "count(revisions), count(isBinary), count(isAdded), count(isDeleted)"}, {"select revisions where date in [2008-10-10, 2008-12-12]", "count(revisions), sum(linesAdded), sum(linesRemoved), average(totalLines)"}, {"select revisions where date in [2008-10-10, 2008-12-12]", "count(revisions), average(linesAdded), max(linesRemoved), min(totalLines)"}, {"select revisions where date in [2008-10-10, 2008-12-12]", "count(revisions), count(distinct path), count(distinct author), count(distinct csid), count(distinct tags), count(distinct reviews)"}, {"select revisions where date in [2008-10-10, 2008-12-12] group by changeset", "count(revisions), count(distinct path), sum(linesAdded), sum(linesRemoved)"}, {"select revisions where date in [2008-10-10, 2008-12-12] group by file", "count(revisions), sum(linesAdded), sum(linesRemoved)"}, {"select revisions where date in [2008-10-10, 2008-12-12]", "count(revisions), count(isBinary), count(isAdded), average(totalLines)"}, {"select revisions where date in [2008-10-10, 2008-12-12] group by directory ", "count(revisions), count(isBinary), count(isAdded), average(totalLines)"}};
    public static final FileRevision[] revisions = new FileRevision[]{new MockTestFileRevision("foo/a.txt", "23", "matt", "2010/01/12", "345", 12, 3, 99).tags("foo"), new MockTestFileRevision("foo/a.txt", "24", "matt", "2010/01/12", "346", 2, 30, 71).tags("foobar"), new MockTestFileRevision("foo/a.txt", "25", "matt", "2010/01/12", "347", 9, 3, 77), new MockTestFileRevision("foo/a.txt", "26", "wilma", "2010/01/13", "348", 55, 8, 124), new MockTestFileRevision("foo/b.txt", "23", "matt", "2010/01/12", "345", 9, 22, 56).tags("foo"), new MockTestFileRevision("foo/b.txt", "24", "matt", "2010/01/12", "346", 34, 34, 56), new MockTestFileRevision("foo/c.txt", "25", "matt", "2010/01/12", "345", 12, 3, 99).tags("foo").reviews(1), new MockTestFileRevision("foo/c.txt", "26", "matt", "2010/01/12", "346", 12, 3, 99).reviews(1), new MockTestFileRevision("foo/c.txt", "27", "fred", "2010/01/14", "349", 12, 3, 99).reviews(1, 2), new MockTestFileRevision("foobar/a.txt", "23", "matt", "2010/01/12", "345", 87, 3, 98).tags("foo", "foobar"), new MockTestFileRevision("foobar/a.txt", "27", "fred", "2010/01/14", "349", 25, 12, 111), new MockTestFileRevision("foobar/a.txt", "29", "barney", "2010/01/15", "350", 44, 23, 132).tags("blah", "wibble", "flob"), new MockTestFileRevision("foobar/b.txt", "23", "matt", "2010/01/12", "345", 30, 0, 30).added().tags("foo"), new MockTestFileRevision("foobar/b.txt", "30", "matt", "2010/01/12", "346", 0, 30, 0).deleted(), new MockTestFileRevision("foobar/c.txt", "23", "matt", "2010/01/12", "345", 30, 0, 30).added().tags("foo"), new MockTestFileRevision("foobar/c.txt", "30", "matt", "2010/01/12", "346", 0, 30, 0).deleted(), new MockTestFileRevision("foobar/d.txt", "30", "dino", "2010/01/16", "351", 0, 0, 99).moved().reviews(2, 3), new MockTestFileRevision("foobar/e.txt", "30", "dino", "2010/01/16", "351", 0, 0, 99).moved(), new MockTestFileRevision("foobar/f.txt", "30", "dino", "2010/01/16", "351", 0, 0, 99).copied(), new MockTestFileRevision("foobar/g.txt", "30", "dino", "2010/01/16", "351", 0, 0, 99).copied().reviews(4), new MockTestFileRevision("foobar/g.txt", "30", "dino", "2010/01/16", "351", 0, 0, 99).copied(), new MockTestFileRevision("foobar/i.jpg", "30", "dino", "2010/01/16", "351", 3, 45, 90).added().binary(), new MockTestFileRevision("foobar/j.jpg", "30", "dino", "2010/01/16", "351", 3, 45, 90).added().binary()};
    public static final Map<String, Object> expectedResults = new HashMap<String, Object>(){
        {
            this.put("maxLinesAdded", 87);
            this.put("maxLinesRemoved", 45);
            this.put("maxTotalLines", 132);
            this.put("minLinesAdded", 0);
            this.put("minLinesRemoved", 0);
            this.put("minTotalLines", 0);
            this.put("averageLinesAdded", 16);
            this.put("averageLinesRemoved", 12);
            this.put("averageTotalLines", 80);
            this.put("sumLinesAdded", 379);
            this.put("sumLinesRemoved", 297);
            this.put("sumTotalLines", 1856);
            this.put("countRevision", revisions.length);
            this.put("countIsBinary", 2);
            this.put("countIsAdded", 4);
            this.put("countIsDeleted", 2);
            this.put("countIsCopied", 3);
            this.put("countIsMoved", 2);
            this.put("countPath", 12);
            this.put("countDir", 2);
            this.put("countAuthor", 5);
            this.put("countDate", 5);
            this.put("countCsid", 7);
            this.put("countTags", 5);
            this.put("countReviews", 4);
        }
    };

    protected void setUp() throws Exception {
        super.setUp();
        DefaultReviewManager.set((ReviewManager)new DummyReviewManager());
    }

    public static FishQuery doParse(String id, String query) {
        ArrayList errors = new ArrayList();
        FishQuery fq = FishQuery.parse((String)query, errors);
        if (!errors.isEmpty()) {
            System.out.println("On Query: " + query);
            System.out.println("Errors: " + errors);
        }
        FishQueryTest.assertTrue((String)id, (boolean)errors.isEmpty());
        return fq;
    }

    private static List<String> createAggregateFields() {
        LinkedList calcFields = Lists.newLinkedList();
        ArrayList numOp = Lists.newArrayList((Object[])new String[]{"max", "min", "average", "sum"});
        ArrayList numFields = Lists.newArrayList((Object[])new String[]{"linesAdded", "linesRemoved", "totalLines"});
        ArrayList countFields = Lists.newArrayList((Object[])new String[]{"revisions", "isBinary", "isAdded", "isDeleted", "isCopied", "isMoved"});
        ArrayList countDistinctFields = Lists.newArrayList((Object[])new String[]{"path", "dir", "author", "date", "csid", "tags", "reviews"});
        for (String op : numOp) {
            for (String field : numFields) {
                calcFields.add(op + "(" + field + ")");
            }
        }
        for (String field : countFields) {
            calcFields.add("count(" + field + ")");
        }
        for (String field : countDistinctFields) {
            calcFields.add("count(distinct " + field + ")");
        }
        return calcFields;
    }

    private static String createAllAggregateFields() {
        return Joiner.on((String)", ").join(FishQueryTest.createAggregateFields());
    }

    private static String createFullQuery(String allAggregateFields) {
        StringBuilder builder = new StringBuilder();
        builder.append("select revisions where path like a.txt group by dir return ");
        builder.append(allAggregateFields);
        return builder.toString();
    }

    public static String createFullQuery() {
        return FishQueryTest.createFullQuery(FishQueryTest.createAllAggregateFields());
    }

    public void testCalculatesParsing() throws Exception {
        for (int i = 0; i < EXAMPLE_AGGREGATE_QUERIES.length; ++i) {
            String[] strings = EXAMPLE_AGGREGATE_QUERIES[i];
            StringBuilder builder = new StringBuilder();
            builder.append(strings[0]);
            if (strings[1] != null) {
                builder.append(" return ");
                builder.append(strings[1]);
            }
            String query = builder.toString();
            this.doTestAggregateClauses("EXAMPLE_AGGREGATE_QUERIES[" + i + "]:" + query, query, strings[1]);
        }
        String allCalcFields = FishQueryTest.createAllAggregateFields();
        this.doTestAggregateClauses("All possible fields", FishQueryTest.createFullQuery(allCalcFields), allCalcFields);
    }

    private void doTestAggregateClauses(String id, String query, String returnClause) {
        FishQuery fq = FishQueryTest.doParse(id, query);
        StringBuffer sb = new StringBuffer();
        fq.getReturnClause().toString(sb);
        FishQueryTest.assertEquals((String)id, (String)returnClause, (String)sb.toString());
    }

    public void testCalculateAggregation() throws Exception {
        ReturnClause clause = FishQueryTest.doParse("all clauses", FishQueryTest.createFullQuery()).getReturnClause();
        ReturnClauseAggregator aggregator = new ReturnClauseAggregator(clause);
        for (FileRevision rev : revisions) {
            aggregator.aggregate(rev);
        }
        Map results = aggregator.getCurrentResults();
        FishQueryTest.assertEquals((int)expectedResults.size(), (int)results.size());
        for (Map.Entry entry : results.entrySet()) {
            ReturnClause.Field field = (ReturnClause.Field)entry.getKey();
            Object result = entry.getValue();
            FishQueryTest.assertTrue((String)field.getColumnName(), (boolean)expectedResults.containsKey(field.getColumnName()));
            FishQueryTest.assertEquals((String)field.getColumnName(), (Object)expectedResults.get(field.getColumnName()), result);
        }
    }
}

