/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.upgrade;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.user.EffectiveUserProvider;
import com.atlassian.fisheye.it.rep.upgrade.AppConfigStub;
import com.atlassian.fisheye.spi.admin.data.GitRepositoryData;
import com.atlassian.fisheye.spi.admin.data.RepositoryData;
import com.atlassian.fisheye.spi.admin.impl.DefaultRepositoryAdminService;
import com.atlassian.fisheye.spi.admin.services.RepositoryAdminService;
import com.atlassian.fugue.Option;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.test.FisheyeTestEnv;
import com.google.common.base.Objects;
import java.io.File;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

@ContextConfiguration(value={"classpath:/com/cenqua/crucible/util/testApplicationContext.xml"})
@DirtiesContext
@RunWith(value=SpringJUnit4ClassRunner.class)
public class GitBranchLatestMarkedChangesetsUpgradeTaskTest
implements ApplicationContextAware {
    private static final String REPO = "GitBranchLatestMarkedChangesetsUpgradeTaskTest";
    @ClassRule
    public static AppConfigStub appConfigStub = new AppConfigStub();
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    @Autowired
    RepositoryManager repositoryManager;
    @Autowired
    EffectiveUserProvider effectiveUserProvider;
    RepositoryAdminService repositoryAdminService;

    @Before
    public void setUp() throws Exception {
        this.repositoryAdminService = new DefaultRepositoryAdminService(this.repositoryManager, null, (EventPublisher)Mockito.mock(EventPublisher.class), this.effectiveUserProvider, null, null, null);
        this.effectiveUserProvider.pushEffectivePrincipal((Principal)Principal.SuperUser.INSTANCE, null);
        AppConfig.getsConfig().refreshLicenses();
    }

    @Test
    public void testUpgradeRepository() throws Exception {
        String repoPath = this.temp.newFolder().getAbsolutePath();
        GitRepositoryData repoData = new GitRepositoryData(REPO, repoPath);
        repoData.setEnabled(Boolean.valueOf(true));
        this.repositoryAdminService.create((RepositoryData)repoData);
        RepositoryHandle handle = this.repositoryManager.getRepository(REPO);
        File cacheDir = handle.getCfg().getCacheDir();
        File globalFe = new File(AppConfig.getCacheDir(), "globalfe");
        IOHelper.unzip((File)new File(FisheyeTestEnv.WORKSPACE_DIR, "test/testfiles/git/caches/git-ancestry-3.7.0.zip"), (File)cacheDir);
        this.repositoryManager.runRepository(REPO);
        handle.withEngine(eng -> {
            RevisionCache cache = eng.getRevisionCache();
            Assert.assertThat((Object)cache.getBranch("master"), (Matcher)new BranchMatching("master", BranchState.ACTIVE, "1d1dc7ff342cc06bd36c66d6a0dc918a4f9a46d9", (Option<String>)Option.some((Object)"1d1dc7ff342cc06bd36c66d6a0dc918a4f9a46d9")));
            Assert.assertThat((Object)cache.getBranch("noHead"), (Matcher)new BranchMatching("noHead", BranchState.ACTIVE, "noHeadCs", (Option<String>)Option.none()));
            Assert.assertThat((Object)cache.getBranch("branch1"), (Matcher)new BranchMatching("branch1", BranchState.ACTIVE, "d0fadf665522491b7a90add36876473ab0b9e4e3", (Option<String>)Option.some((Object)"d0fadf665522491b7a90add36876473ab0b9e4e3")));
            Assert.assertThat((Object)cache.getBranch("branch2"), (Matcher)new BranchMatching("branch2", BranchState.ACTIVE, "e128bf2f78883ebb04973b7e33d6b83b469672f6", (Option<String>)Option.some((Object)"e128bf2f78883ebb04973b7e33d6b83b469672f6")));
            Assert.assertThat((Object)cache.getBranch("deleted"), (Matcher)new BranchMatching("deleted", BranchState.REMOVED, null, (Option<String>)Option.none()));
            return null;
        });
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        SpringContext.setApplicationContext((ApplicationContext)applicationContext);
    }

    @After
    public void tearDown() throws Exception {
        this.repositoryManager.fullShutdown();
        this.effectiveUserProvider.popEffectivePrincipal();
        SpringContext.setApplicationContext(null);
    }

    private static class BranchMatching
    extends TypeSafeMatcher<Branch> {
        private final String name;
        private final BranchState state;
        private final String headCsId;
        private final Option<String> lastMarkedCsId;

        public BranchMatching(String name, BranchState state, String headCsId, Option<String> lastMarkedCsId) {
            this.name = name;
            this.state = state;
            this.headCsId = headCsId;
            this.lastMarkedCsId = lastMarkedCsId;
        }

        protected boolean matchesSafely(Branch item) {
            return item != null && Objects.equal((Object)item.getName(), (Object)this.name) && Objects.equal((Object)item.getState(), (Object)this.state) && Objects.equal((Object)item.getLatestChangeSetId(), (Object)this.headCsId) && Objects.equal((Object)item.getLatestMarkedChangesetId(), this.lastMarkedCsId);
        }

        public void describeTo(Description description) {
            Branch branch = new Branch(this.name, this.headCsId, this.state);
            branch.setLatestMarkedChangesetId(this.lastMarkedCsId);
            description.appendText("Branch matching ").appendValue((Object)branch);
        }
    }
}

