/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.upgrade;

import com.atlassian.fecru.search.index.model.DocInfo;
import com.atlassian.fecru.search.index.service.TestDocInfoManager;
import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.crossrepo.BranchDoc;
import com.cenqua.fisheye.crossrepo.BranchDocInfo;
import com.cenqua.fisheye.crossrepo.BranchQueryBuilder;
import com.cenqua.fisheye.crossrepo.ChangesetDoc;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.upgrade.BranchIndexingRepoUpgradeTask;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Files;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class BranchIndexingRepoUpgradeTaskTest {
    private static final String REP_NAME = "rep1";
    private File tempDir;
    private CrossRepLuceneIndex index;

    @Before
    public void setUp() throws Exception {
        this.tempDir = Files.createTempDir();
        this.index = new CrossRepLuceneIndex(this.tempDir);
    }

    @After
    public void tearDown() throws Exception {
        this.index.getConnection().close();
        FileUtils.deleteQuietly((File)this.tempDir);
    }

    @Test
    public void testUpgradeRepository() throws Exception {
        this.index.getConnection().withWriter((LuceneConnection.IndexConfig)CrossRepLuceneIndexes.METADATA, writer -> {
            TestDocInfoManager manager = new TestDocInfoManager(writer, null);
            manager.addDoc((DocInfo)BranchDocInfo.fromBranchDoc((BranchDoc)new BranchDoc(REP_NAME, null, 0L, "abc", BranchState.ACTIVE, -1L, -1L)));
            manager.addDoc((DocInfo)BranchDocInfo.fromBranchDoc((BranchDoc)new BranchDoc(REP_NAME, null, 0L, "ced", BranchState.ACTIVE, -1L, -1L)));
            manager.addDoc((DocInfo)new ChangesetDocInfo(ChangesetDoc.fromChangeSet((ChangeSet)FisheyeTestUtil.mockChangeSet(REP_NAME, "cs1", "test")), false));
            manager.commit();
            return null;
        });
        RepositoryEngine engine = (RepositoryEngine)Mockito.mock(RepositoryEngine.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)engine.getCrossRepLuceneIndex()).thenReturn((Object)this.index);
        Mockito.when((Object)engine.getInternalRevisionCache().getBranches()).thenReturn((Object)ImmutableSet.of((Object)new Branch("abc")));
        Mockito.when((Object)engine.getInternalRevisionCache().getRepositoryName()).thenReturn((Object)REP_NAME);
        Mockito.when((Object)engine.getStatus().getRepositoryName()).thenReturn((Object)REP_NAME);
        new BranchIndexingRepoUpgradeTask().doUpgrade(engine);
        this.index.getConnection().withIndexReader((LuceneConnection.IndexConfig)CrossRepLuceneIndexes.METADATA, indexReader -> {
            TestDocInfoManager manager = new TestDocInfoManager(null, indexReader);
            Assert.assertThat((Object)manager.countDocs(BranchQueryBuilder.queryByDocType()), (Matcher)Matchers.equalTo((Object)1));
            Assert.assertThat((Object)((BranchDocInfo)manager.findDoc(BranchQueryBuilder.queryByDocType(), BranchDocInfo.CONVERTER)).getBranch(), (Matcher)Matchers.equalTo((Object)"abc"));
            Assert.assertThat((Object)manager.countDocs(ChangesetQueryBuilder.newBuilder((String)REP_NAME).changesetsOnly().build()), (Matcher)Matchers.equalTo((Object)1));
            return null;
        });
    }
}

