/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.upgrade;

import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.upgrade.AbstractRepositoryVersionUpgradeTask;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class AbstractRepositoryVersionUpgradeTaskTest {
    @Test
    public void testCanUpgrade_returnsUpgradeToFromMap() throws Exception {
        ScmType type = ScmType.SVN;
        DummyRepositoryVersionUpgradeTisk task = new DummyRepositoryVersionUpgradeTisk((Map<ScmType, Integer>)ImmutableMap.of((Object)type, (Object)28));
        Assert.assertThat((Object)task.canUpgrade(type, 27), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)task.canUpgrade(type, 28), (Matcher)Matchers.is((Object)29));
        Assert.assertThat((Object)task.canUpgrade(type, 29), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testCanUpgrade_returnsUpgradeToFromMultimap() throws Exception {
        ScmType type = ScmType.SVN;
        DummyRepositoryVersionUpgradeTisk task = new DummyRepositoryVersionUpgradeTisk((Multimap<ScmType, Integer>)ImmutableMultimap.builder().putAll((Object)type, (Object[])new Integer[]{28, 30}).build());
        Assert.assertThat((Object)task.canUpgrade(type, 27), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)task.canUpgrade(type, 28), (Matcher)Matchers.is((Object)29));
        Assert.assertThat((Object)task.canUpgrade(type, 29), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)task.canUpgrade(type, 30), (Matcher)Matchers.is((Object)31));
        Assert.assertThat((Object)task.canUpgrade(type, 31), (Matcher)Matchers.nullValue());
    }

    static class DummyRepositoryVersionUpgradeTisk
    extends AbstractRepositoryVersionUpgradeTask {
        DummyRepositoryVersionUpgradeTisk(Map<ScmType, Integer> upgradeMap) {
            super(upgradeMap);
        }

        DummyRepositoryVersionUpgradeTisk(Multimap<ScmType, Integer> multiUpgradeMap) {
            super(multiUpgradeMap);
        }

        public void upgradeRepository(RepositoryEngine engine, RevisionCacheProperties props) throws IOException {
        }

        public String getName() {
            return null;
        }
    }
}

