/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.selectionhistory;

import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.selectionhistory.PerLineHistoryResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PerLineHistoryResultTest {
    private PerLineHistoryResult result;

    @Before
    public void setUp() throws Exception {
        this.result = new PerLineHistoryResult();
    }

    @Test
    public void testAddResult() throws Exception {
        FileRevision rev1 = (FileRevision)Mockito.mock(FileRevision.class);
        FileRevision rev2 = (FileRevision)Mockito.mock(FileRevision.class);
        FileRevision rev3 = (FileRevision)Mockito.mock(FileRevision.class);
        FileRevision rev4 = (FileRevision)Mockito.mock(FileRevision.class);
        FileRevision rev5 = (FileRevision)Mockito.mock(FileRevision.class);
        PerLineHistoryResult.Revision match1 = new PerLineHistoryResult.Revision(rev1, true, 2);
        PerLineHistoryResult.Revision match2 = new PerLineHistoryResult.Revision(rev1, true, 1);
        PerLineHistoryResult.Revision match3 = new PerLineHistoryResult.Revision(rev2, true, 3);
        PerLineHistoryResult.Revision match4 = new PerLineHistoryResult.Revision(rev3, true, 3);
        PerLineHistoryResult.Revision nonmatch1 = new PerLineHistoryResult.Revision(rev4, false, 1);
        PerLineHistoryResult.Revision nonmatch2 = new PerLineHistoryResult.Revision(rev5, false, 2);
        this.result.addResult(match1);
        this.assertEquivalent(this.result, match1);
        this.result.addResult(match2);
        this.assertEquivalent(this.result, match1);
        Assert.assertEquals((long)1L, (long)match1.getSelectedLine());
        this.result.addResult(match3);
        this.assertEquivalent(this.result, match1, match3);
        this.result.addResult(nonmatch1);
        this.assertEquivalent(this.result, match1, match3, nonmatch1);
        this.result.addResult(nonmatch2);
        this.assertEquivalent(this.result, match1, match3, nonmatch2);
        this.result.addResult(match4);
        this.assertEquivalent(this.result, match1, match3, match4, nonmatch2);
    }

    private void assertEquivalent(PerLineHistoryResult results, PerLineHistoryResult.Revision ... revisions) {
        Assert.assertEquals((long)revisions.length, (long)results.size());
        for (int i = 0; i < revisions.length; ++i) {
            Assert.assertEquals((Object)revisions[i], (Object)results.get(i));
        }
    }
}

