/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.selectionhistory;

import com.cenqua.fisheye.diff.DiffTest;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.diff.HunkList;
import com.cenqua.fisheye.diff.Section;
import com.cenqua.fisheye.rep.selectionhistory.LineRanges;
import com.cenqua.fisheye.rep.selectionhistory.MatchableLineRanges;
import com.cenqua.fisheye.rep.selectionhistory.PerLineHistoryDiffHelper;
import com.cenqua.fisheye.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import junit.framework.TestCase;

public class PerLineHistoryDiffHelperTest
extends TestCase {
    private PerLineHistoryDiffHelper diffHelper;
    private String[] oldFile = new String[]{"", "", "", "", "a", "", "", "", "", "b", "", "", "", "", "c", "", "", "", "", "d", "", "", "", "", "e", "", "", "", "", "f", "", "", "", "", "g", "", "", "", "", "h", "", "", "", ""};
    private String[] newFile = new String[]{"", "", "", "", "a", "", "", "", "", "", "", "", "", "c", "", "", "", "", "d", "", "", "", "", "e", "", "", "", "", "ff", "", "", "", "", "g", "", "", "", "", "x", "h", "", "", "", ""};

    public void setUp() throws Exception {
        this.diffHelper = new PerLineHistoryDiffHelper(false);
    }

    public void testAllPrevLines() throws Exception {
        this.testAllPrevLines("original vs rev1", DiffTest.original, DiffTest.rev1);
        this.testAllPrevLines("rev1 vs rev2", DiffTest.rev1, DiffTest.rev2);
        this.testAllPrevLines("rev2 vs rev3", DiffTest.rev2, DiffTest.rev3);
        this.testAllPrevLines("lao vs tzu", DiffTest.lao, DiffTest.tzu);
    }

    public void testAllPrevLinesIndividually() throws Exception {
        this.testAllPrevLinesIndividually("original vs rev1", DiffTest.original, DiffTest.rev1);
        this.testAllPrevLinesIndividually("rev1 vs rev2", DiffTest.rev1, DiffTest.rev2);
        this.testAllPrevLinesIndividually("rev2 vs rev3", DiffTest.rev2, DiffTest.rev3);
        this.testAllPrevLinesIndividually("lao vs tzu", DiffTest.lao, DiffTest.tzu);
    }

    private void testAllPrevLines(String message, String[] orig, String[] rev) throws Exception {
        HunkList hunks = DiffTest.diff(orig, rev);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        prevLines.addRanges((LineRanges)this.diffHelper.getPrevLines(sections, 0, rev.length - 1));
        PerLineHistoryDiffHelperTest.assertEquals((String)(message + ": wrong number of ranges"), (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)(message + ": wrong start"), (int)0, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)(message + ": wrong end"), (int)(orig.length - 1), (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testAllPrevLinesMultipleRanges() throws Exception {
        this.testAllPrevLines("original vs rev1", DiffTest.original, DiffTest.rev1);
        HunkList hunks = DiffTest.diff(DiffTest.original, DiffTest.rev1);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        prevLines.addRanges((LineRanges)this.diffHelper.getPrevLines(sections, new LineRanges(Arrays.asList(Pair.newInstance((Object)0, (Object)2), Pair.newInstance((Object)3, (Object)(DiffTest.rev1.length - 1))))));
        PerLineHistoryDiffHelperTest.assertEquals((String)"original vs rev1: wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"original vs rev1: wrong start", (int)0, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"original vs rev1: wrong end", (int)(DiffTest.original.length - 1), (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    private void testAllPrevLinesIndividually(String message, String[] orig, String[] rev) throws Exception {
        HunkList hunks = DiffTest.diff(orig, rev);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        Section prevSection = null;
        for (Section section : sections) {
            prevLines.addRanges(this.diffHelper.getPrevLines(prevSection, section, 0, orig.length));
            prevSection = section;
        }
        prevLines = prevLines.flatten();
        PerLineHistoryDiffHelperTest.assertEquals((String)(message + ": wrong number of ranges"), (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)(message + ": wrong start"), (int)0, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)(message + ": wrong end"), (int)(orig.length - 1), (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testNewLine() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev2, DiffTest.rev3);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        prevLines.addRanges((LineRanges)this.diffHelper.getPrevLines(sections, 2, 2));
        PerLineHistoryDiffHelperTest.assertEquals((int)0, (int)prevLines.getRanges().size());
    }

    public void testNewLineIndividually() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev2, DiffTest.rev3);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        Section prevSection = null;
        for (Section section : sections) {
            prevLines.addRanges(this.diffHelper.getPrevLines(prevSection, section, 2, 0));
            prevSection = section;
        }
        PerLineHistoryDiffHelperTest.assertEquals((int)0, (int)prevLines.getRanges().size());
    }

    public void testDeleteAtEnd() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev3, DiffTest.rev4);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        prevLines.addRanges((LineRanges)this.diffHelper.getPrevLines(sections, 2, 5));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)6, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)11, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testDeleteAtEndIndividually() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev3, DiffTest.rev4);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        Section prevSection = null;
        for (Section section : sections) {
            prevLines.addRanges(this.diffHelper.getPrevLines(prevSection, section, 6, 4));
            prevSection = section;
        }
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)6, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)9, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testDeleteAtStart() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev3, DiffTest.rev4);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        prevLines.addRanges((LineRanges)this.diffHelper.getPrevLines(sections, 0, 0));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)0, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)4, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testDeleteAtStartIndividually() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev3, DiffTest.rev4);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        Section prevSection = null;
        for (Section section : sections) {
            prevLines.addRanges(this.diffHelper.getPrevLines(prevSection, section, 3, 1));
            prevSection = section;
        }
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)3, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)3, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testDeleteInMiddle() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev3, DiffTest.rev4);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        prevLines.addRanges((LineRanges)this.diffHelper.getPrevLines(sections, 0, 1));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)0, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)5, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testDeleteInMiddleIndividually() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev3, DiffTest.rev4);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        Section prevSection = null;
        for (Section section : sections) {
            prevLines.addRanges(this.diffHelper.getPrevLines(prevSection, section, 3, 3));
            prevSection = section;
        }
        prevLines = prevLines.flatten();
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)3, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)5, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testAddAtEnd() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev4, DiffTest.rev3);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        prevLines.addRanges((LineRanges)this.diffHelper.getPrevLines(sections, 6, 11));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)2, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)5, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testAddAtEndIndividually() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev4, DiffTest.rev3);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        Section prevSection = null;
        for (Section section : sections) {
            prevLines.addRanges(this.diffHelper.getPrevLines(prevSection, section, 2, 4));
            prevSection = section;
        }
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)2, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)5, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testAddAtStart() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev4, DiffTest.rev3);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        prevLines.addRanges((LineRanges)this.diffHelper.getPrevLines(sections, 0, 3));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)0, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)0, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testAddAtStartIndividually() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev4, DiffTest.rev3);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        Section prevSection = null;
        for (Section section : sections) {
            prevLines.addRanges(this.diffHelper.getPrevLines(prevSection, section, 0, 1));
            prevSection = section;
        }
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)0, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)0, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testAddInMiddle() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev4, DiffTest.rev3);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        prevLines.addRanges((LineRanges)this.diffHelper.getPrevLines(sections, 3, 5));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)0, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)1, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testAddInMiddleIndividually() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev4, DiffTest.rev3);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        Section prevSection = null;
        for (Section section : sections) {
            prevLines.addRanges(this.diffHelper.getPrevLines(prevSection, section, 0, 2));
            prevSection = section;
        }
        prevLines = prevLines.flatten();
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)0, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)1, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testPartialHunk() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev2, DiffTest.rev3);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        prevLines.addRanges((LineRanges)this.diffHelper.getPrevLines(sections, 7, 7));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)6, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)7, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testPartialHunkIndividually() throws Exception {
        HunkList hunks = DiffTest.diff(DiffTest.rev2, DiffTest.rev3);
        List sections = hunks.getSections(-1);
        LineRanges prevLines = new LineRanges();
        Section prevSection = null;
        for (Section section : sections) {
            prevLines.addRanges(this.diffHelper.getPrevLines(prevSection, section, 7, 1));
            prevSection = section;
        }
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong number of ranges", (int)1, (int)prevLines.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong start", (int)6, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((String)"wrong end", (int)7, (int)((Integer)((Pair)prevLines.getRanges().get(0)).getSecond()));
    }

    public void testFileLengths() throws Exception {
        Hunk hunk = new Hunk(3, 4, 1, 2);
        ArrayList<Hunk> hunks = new ArrayList<Hunk>();
        hunks.add(hunk);
        Pair fileLengths = this.diffHelper.getPaddedFileLengths(hunks, 10);
        PerLineHistoryDiffHelperTest.assertEquals((int)10, (int)((Integer)fileLengths.getSecond()));
        PerLineHistoryDiffHelperTest.assertEquals((int)8, (int)((Integer)fileLengths.getFirst()));
        fileLengths = this.diffHelper.getPaddedFileLengths(hunks, 1);
        PerLineHistoryDiffHelperTest.assertEquals((int)6, (int)((Integer)fileLengths.getSecond()));
        PerLineHistoryDiffHelperTest.assertEquals((int)4, (int)((Integer)fileLengths.getFirst()));
        hunk = Hunk.createUnifiedAddHunk((int)3, (int)4, (int)2);
        hunks = new ArrayList();
        hunks.add(hunk);
        fileLengths = this.diffHelper.getPaddedFileLengths(hunks, 10);
        PerLineHistoryDiffHelperTest.assertEquals((int)10, (int)((Integer)fileLengths.getSecond()));
        PerLineHistoryDiffHelperTest.assertEquals((int)6, (int)((Integer)fileLengths.getFirst()));
        fileLengths = this.diffHelper.getPaddedFileLengths(hunks, 1);
        PerLineHistoryDiffHelperTest.assertEquals((int)6, (int)((Integer)fileLengths.getSecond()));
        PerLineHistoryDiffHelperTest.assertEquals((int)2, (int)((Integer)fileLengths.getFirst()));
        hunk = Hunk.createUnifiedDeleteHunk((int)3, (int)4, (int)2);
        hunks = new ArrayList();
        hunks.add(hunk);
        fileLengths = this.diffHelper.getPaddedFileLengths(hunks, 10);
        PerLineHistoryDiffHelperTest.assertEquals((int)10, (int)((Integer)fileLengths.getSecond()));
        PerLineHistoryDiffHelperTest.assertEquals((int)12, (int)((Integer)fileLengths.getFirst()));
        fileLengths = this.diffHelper.getPaddedFileLengths(hunks, 1);
        PerLineHistoryDiffHelperTest.assertEquals((int)3, (int)((Integer)fileLengths.getSecond()));
        PerLineHistoryDiffHelperTest.assertEquals((int)5, (int)((Integer)fileLengths.getFirst()));
    }

    public void testGetSections() throws Exception {
        Hunk hunk = new Hunk(6, 7, 1, 2);
        ArrayList<Hunk> hunks = new ArrayList<Hunk>();
        hunks.add(hunk);
        List paddedSection = this.diffHelper.getPaddedSections(hunks, 10);
        PerLineHistoryDiffHelperTest.assertEquals((int)3, (int)paddedSection.size());
        PerLineHistoryDiffHelperTest.assertTrue((boolean)((Section)paddedSection.get(0)).isCommonSubsequence());
        PerLineHistoryDiffHelperTest.assertEquals((Object)new Section(false, hunk), paddedSection.get(1));
        Section finalSection = (Section)paddedSection.get(2);
        PerLineHistoryDiffHelperTest.assertTrue((boolean)finalSection.isCommonSubsequence());
        PerLineHistoryDiffHelperTest.assertEquals((int)11, (int)(finalSection.getToStart() + finalSection.getToLength()));
        paddedSection = this.diffHelper.getPaddedSections(hunks, 3);
        PerLineHistoryDiffHelperTest.assertEquals((int)2, (int)paddedSection.size());
        PerLineHistoryDiffHelperTest.assertTrue((boolean)((Section)paddedSection.get(0)).isCommonSubsequence());
        PerLineHistoryDiffHelperTest.assertEquals((Object)new Section(false, hunk), paddedSection.get(1));
    }

    public void testSingleLineOnCommonSubsequence() throws Exception {
        LineRanges ranges = new LineRanges(10, 10);
        MatchableLineRanges prevLinesByHunks = this.diffHelper.getPrevLinesByHunks(Collections.emptyList(), ranges);
        PerLineHistoryDiffHelperTest.assertFalse((boolean)prevLinesByHunks.isMatch());
        PerLineHistoryDiffHelperTest.assertEquals((int)1, (int)prevLinesByHunks.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((int)10, (int)((Integer)((Pair)prevLinesByHunks.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((int)10, (int)((Integer)((Pair)prevLinesByHunks.getRanges().get(0)).getSecond()));
    }

    public void testAll() throws Exception {
        HunkList hunklist = DiffTest.diff(this.oldFile, this.newFile);
        ArrayList hunks = new ArrayList();
        Iterator it = hunklist.getIterator();
        while (it.hasNext()) {
            hunks.add(it.next());
        }
        this.assertMatchableLineRange(this.diffHelper.getPrevLinesByHunks(hunks, new LineRanges(1)), false, 1);
        this.assertMatchableLineRange(this.diffHelper.getPrevLinesByHunks(hunks, new LineRanges(7)), false, 7);
        this.assertMatchableLineRange(this.diffHelper.getPrevLinesByHunks(hunks, new LineRanges(8)), true, 8, 9);
        this.assertMatchableLineRange(this.diffHelper.getPrevLinesByHunks(hunks, new LineRanges(9)), true, 9, 10);
        this.assertMatchableLineRange(this.diffHelper.getPrevLinesByHunks(hunks, new LineRanges(10)), false, 11);
        this.assertMatchableLineRange(this.diffHelper.getPrevLinesByHunks(hunks, new LineRanges(27)), false, 28);
        this.assertMatchableLineRange(this.diffHelper.getPrevLinesByHunks(hunks, new LineRanges(28)), true, 29);
        this.assertMatchableLineRange(this.diffHelper.getPrevLinesByHunks(hunks, new LineRanges(29)), false, 30);
        this.assertMatchableLineRange(this.diffHelper.getPrevLinesByHunks(hunks, new LineRanges(37)), false, 38);
        this.assertNewLineMatch(this.diffHelper.getPrevLinesByHunks(hunks, new LineRanges(38)));
        this.assertMatchableLineRange(this.diffHelper.getPrevLinesByHunks(hunks, new LineRanges(39)), false, 39);
        this.assertMatchableLineRange(this.diffHelper.getPrevLinesByHunks(hunks, new LineRanges(43)), false, 43);
    }

    private void assertMatchableLineRange(MatchableLineRanges prevLinesByHunks, boolean match, int singleLine) {
        this.assertMatchableLineRange(prevLinesByHunks, match, singleLine, singleLine);
    }

    private void assertMatchableLineRange(MatchableLineRanges prevLinesByHunks, boolean match, int min, int max) {
        PerLineHistoryDiffHelperTest.assertEquals((boolean)match, (boolean)prevLinesByHunks.isMatch());
        PerLineHistoryDiffHelperTest.assertEquals((int)1, (int)prevLinesByHunks.getRanges().size());
        PerLineHistoryDiffHelperTest.assertEquals((int)min, (int)((Integer)((Pair)prevLinesByHunks.getRanges().get(0)).getFirst()));
        PerLineHistoryDiffHelperTest.assertEquals((int)max, (int)((Integer)((Pair)prevLinesByHunks.getRanges().get(0)).getSecond()));
    }

    private void assertNewLineMatch(MatchableLineRanges prevLinesByHunks) {
        PerLineHistoryDiffHelperTest.assertEquals((boolean)true, (boolean)prevLinesByHunks.isMatch());
        PerLineHistoryDiffHelperTest.assertEquals((int)0, (int)prevLinesByHunks.getRanges().size());
    }

    public void testFromLineNumberEquiv() throws Exception {
        this.diffHelper = new PerLineHistoryDiffHelper();
        Section s1 = new Section(true, new Hunk(1, 1, 27, 27));
        Section s2 = new Section(true, new Hunk(28, 28, 2, 2));
        Section s3 = new Section(true, new Hunk(30, 30, 5, 4));
        Section s4 = new Section(true, new Hunk(35, 34, 13, 0));
        Section s5 = new Section(true, new Hunk(48, 34, 4, 4));
        Section s6 = new Section(true, new Hunk(52, 38, 1, 0));
        Section s7 = new Section(true, new Hunk(53, 38, 2, 3));
        Section s8 = new Section(true, new Hunk(55, 41, 1, 1));
        Section s9 = new Section(true, new Hunk(56, 42, 2, 3));
        Section s10 = new Section(true, new Hunk(58, 45, 0, 2));
        Section s11 = new Section(true, new Hunk(58, 47, 2, 2));
        this.assertEquivLineNumber(null, s1, 27, 27);
        this.assertEquivLineNumber(s1, s2, 28, 28);
        this.assertEquivLineNumber(s1, s2, 29, 29);
        this.assertEquivLineNumber(s2, s3, 30, 30);
        this.assertEquivLineNumber(s2, s3, 34, 34);
        this.assertEquivLineNumber(s4, s5, 35, 48);
        this.assertEquivLineNumber(s4, s5, 38, 51);
        this.assertEquivLineNumber(s6, s7, 39, 53);
        this.assertEquivLineNumber(s6, s7, 40, 54);
        this.assertEquivLineNumber(s7, s8, 41, 55);
        this.assertEquivLineNumber(s8, s9, 42, 56);
        this.assertEquivLineNumber(s8, s9, 44, 58);
        this.assertEquivLineNumber(s9, s10, 45, 58);
        this.assertEquivLineNumber(s9, s10, 46, 59);
        this.assertEquivLineNumber(s10, s11, 47, 59);
        this.assertEquivLineNumber(s10, s11, 56, 68);
    }

    private void assertEquivLineNumber(Section prevSection, Section section, int toLine, int expectedFromLine) {
        PerLineHistoryDiffHelperTest.assertEquals((int)expectedFromLine, (int)this.diffHelper.getFromLineNumberEquiv(prevSection, section, toLine));
    }

    public void testPadding() throws Exception {
        this.diffHelper = new PerLineHistoryDiffHelper(true);
        ArrayList<Hunk> hunks = new ArrayList<Hunk>();
        hunks.add(new Hunk(51, 52, 0, 1));
        Pair paddedFileLengths = this.diffHelper.getPaddedFileLengths(hunks, 61);
        List paddedSections = this.diffHelper.getPaddedSections(hunks, 61);
        System.out.println(paddedFileLengths);
        for (Section section : paddedSections) {
            System.out.println(section);
        }
        this.assertEquivLineNumber((Section)paddedSections.get(1), (Section)paddedSections.get(2), 61, 60);
    }
}

