/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.selectionhistory;

import com.cenqua.fisheye.rep.selectionhistory.LineRanges;
import com.cenqua.fisheye.util.Pair;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LineRangesTest {
    LineRanges THREE_TO_FIVE;
    LineRanges SEVEN_TO_SEVEN;
    LineRanges EIGHT_TO_NINE;
    LineRanges THREE_TO_FIVE_AND_SEVEN_TO_SEVEN;
    LineRanges SEVEN_AND_EIGHT_TO_NINE;
    LineRanges FLATTENED;

    @Before
    public void setUp() throws Exception {
        this.THREE_TO_FIVE = new LineRanges(Arrays.asList(Pair.newInstance((Object)3, (Object)5)));
        this.SEVEN_TO_SEVEN = new LineRanges(Arrays.asList(Pair.newInstance((Object)7, (Object)7)));
        this.EIGHT_TO_NINE = new LineRanges(Arrays.asList(Pair.newInstance((Object)8, (Object)9)));
        this.THREE_TO_FIVE_AND_SEVEN_TO_SEVEN = new LineRanges(Arrays.asList(Pair.newInstance((Object)3, (Object)5), Pair.newInstance((Object)7, (Object)7)));
        this.SEVEN_AND_EIGHT_TO_NINE = new LineRanges(Arrays.asList(Pair.newInstance((Object)7, (Object)7), Pair.newInstance((Object)8, (Object)9)));
        this.FLATTENED = new LineRanges(Arrays.asList(Pair.newInstance((Object)3, (Object)5), Pair.newInstance((Object)7, (Object)9)));
    }

    @Test
    public void testMin() throws Exception {
        Assert.assertEquals((long)3L, (long)this.THREE_TO_FIVE.getMin());
        Assert.assertEquals((long)7L, (long)this.SEVEN_TO_SEVEN.getMin());
        Assert.assertEquals((long)8L, (long)this.EIGHT_TO_NINE.getMin());
        Assert.assertEquals((long)3L, (long)this.THREE_TO_FIVE_AND_SEVEN_TO_SEVEN.getMin());
        Assert.assertEquals((long)7L, (long)this.SEVEN_AND_EIGHT_TO_NINE.getMin());
        Assert.assertEquals((long)3L, (long)this.FLATTENED.getMin());
    }

    @Test
    public void testMax() throws Exception {
        Assert.assertEquals((long)5L, (long)this.THREE_TO_FIVE.getMax());
        Assert.assertEquals((long)7L, (long)this.SEVEN_TO_SEVEN.getMax());
        Assert.assertEquals((long)9L, (long)this.EIGHT_TO_NINE.getMax());
        Assert.assertEquals((long)7L, (long)this.THREE_TO_FIVE_AND_SEVEN_TO_SEVEN.getMax());
        Assert.assertEquals((long)9L, (long)this.SEVEN_AND_EIGHT_TO_NINE.getMax());
        Assert.assertEquals((long)9L, (long)this.FLATTENED.getMax());
    }

    @Test
    public void testFlatten() throws Exception {
        LineRanges lineRanges = new LineRanges(this.THREE_TO_FIVE.ranges);
        lineRanges.addRange(7, 7);
        lineRanges.addRanges(this.EIGHT_TO_NINE);
        lineRanges.addRanges(this.THREE_TO_FIVE_AND_SEVEN_TO_SEVEN);
        lineRanges.addRanges(this.SEVEN_AND_EIGHT_TO_NINE);
        lineRanges = lineRanges.flatten();
        Assert.assertEquals((long)2L, (long)lineRanges.ranges.size());
        Assert.assertEquals((Object)Pair.newInstance((Object)3, (Object)5), lineRanges.ranges.get(0));
        Assert.assertEquals((Object)Pair.newInstance((Object)7, (Object)9), lineRanges.ranges.get(1));
    }

    @Test
    public void testTooFarFromOrigin() throws Exception {
        LineRanges ranges = new LineRanges(Arrays.asList(Pair.newInstance((Object)20, (Object)180)));
        Assert.assertFalse((boolean)ranges.isTooFarFromSelection(20, 180));
        Assert.assertFalse((boolean)ranges.isTooFarFromSelection(10, 190));
        Assert.assertFalse((boolean)ranges.isTooFarFromSelection(10, 170));
        Assert.assertFalse((boolean)ranges.isTooFarFromSelection(30, 190));
        Assert.assertFalse((boolean)ranges.isTooFarFromSelection(30, 170));
        Assert.assertTrue((boolean)ranges.isTooFarFromSelection(1, 1));
        Assert.assertTrue((boolean)ranges.isTooFarFromSelection(200, 200));
        Assert.assertTrue((boolean)ranges.isTooFarFromSelection(20, 25));
        Assert.assertTrue((boolean)ranges.isTooFarFromSelection(175, 180));
        Assert.assertTrue((boolean)ranges.isTooFarFromSelection(100, 100));
        Assert.assertTrue((boolean)ranges.isTooFarFromSelection(1, 54));
        Assert.assertFalse((boolean)ranges.isTooFarFromSelection(1, 55));
    }
}

