/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl.ancestry;

import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.util.Disposable;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;

public abstract class ChangeSetDAOAncestryTestBase {
    protected static DisposableRevisionCache cache;
    private final Supplier<DisposableRevisionCache> disposableRevisionCacheSupplier;
    private static final Function<ChangeSet, String> CHANGE_SET_TO_COMMENT;
    private final Function<String, ChangeSet> CSID_TO_CHANGE_SET = csId -> this.getCache().getChangeSet(csId);

    protected ChangeSetDAOAncestryTestBase(Supplier<DisposableRevisionCache> disposableRevisionCacheSupplier) {
        this.disposableRevisionCacheSupplier = disposableRevisionCacheSupplier;
    }

    @Before
    public void setUp() throws Exception {
        if (cache == null) {
            cache = (DisposableRevisionCache)this.disposableRevisionCacheSupplier.get();
        }
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (cache != null) {
            try {
                cache.dispose();
            }
            finally {
                cache = null;
            }
        }
    }

    protected void testCase(String baseBranchName, String featureBranchName, Ancestry expected) throws Exception {
        this.testCase(baseBranchName, featureBranchName, 100, expected);
    }

    protected void testCase(String baseBranchName, String featureBranchName, int limit, Ancestry expected) throws Exception {
        RevisionCache<? extends ChangeSet> cache = this.getCache();
        Branch featureBranch = cache.getBranch(featureBranchName);
        String startCsId = featureBranch.getLatestChangeSetId();
        AtomicReference topmostBranchPoint = new AtomicReference();
        Set<Branch> excludedBranches = Collections.singleton(this.getCache().getBranch(baseBranchName));
        Set ancestryIds = cache.getChangeSetAncestors(startCsId, limit, excludedBranches, topmostBranchPoint);
        Iterable ancestryChangeSets = Iterables.transform((Iterable)ancestryIds, this.CSID_TO_CHANGE_SET);
        Iterable filteredChangeSets = Iterables.filter((Iterable)ancestryChangeSets, this.getCommentFilter());
        Iterable ancestryComments = Iterables.transform((Iterable)filteredChangeSets, CHANGE_SET_TO_COMMENT);
        Assert.assertThat((String)"ancestry commits", (Object)ancestryComments, (Matcher)Matchers.containsInAnyOrder((Object[])expected.getComments()));
        if (expected.getBranchPointComment() != null) {
            String branchPointComment = (String)CHANGE_SET_TO_COMMENT.apply(this.CSID_TO_CHANGE_SET.apply(topmostBranchPoint.get()));
            Assert.assertThat((String)"branch point commit", (Object)branchPointComment, (Matcher)Matchers.is((Object)expected.getBranchPointComment()));
        }
    }

    protected RevisionCache<? extends ChangeSet> getCache() {
        return cache.getCache();
    }

    public Predicate<ChangeSet> getCommentFilter() {
        return Predicates.alwaysTrue();
    }

    public Ancestry ancestry() {
        return new Ancestry();
    }

    static {
        CHANGE_SET_TO_COMMENT = changeSet -> {
            String comment = changeSet.getComment();
            return comment != null ? comment.trim() : null;
        };
    }

    public static class Ancestry {
        private String branchPointComment;
        private Iterable<String> comments = Collections.emptyList();

        private Ancestry() {
        }

        @Nullable
        public String getBranchPointComment() {
            return this.branchPointComment;
        }

        public String[] getComments() {
            return (String[])Iterables.toArray(this.comments, String.class);
        }

        public Ancestry comments(Iterable<String> comments) {
            this.comments = comments;
            return this;
        }

        public Ancestry commmits(String ... comments) {
            return this.comments(Arrays.asList(comments));
        }

        public Ancestry branchPoint(String branchPointComment) {
            this.branchPointComment = branchPointComment;
            return this;
        }
    }

    protected static interface DisposableRevisionCache
    extends Disposable {
        public RevisionCache getCache();
    }
}

