/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fisheye.hg.HgCache;
import com.atlassian.fisheye.hg.client.HgContext;
import com.atlassian.fisheye.hg.db.HgChangeSet;
import com.atlassian.fisheye.hg.db.HgRevInfo;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.MutableChangeSet;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import com.cenqua.fisheye.rep.impl.TopologicalOrderChangesetIterator;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TopologicalOrderChangeSetIteratorTest {
    private static final String A = "aaaaaaaaaaaa";
    private static final String B = "bbbbbbbbbbbb";
    private static final String C = "cccccccccccc";
    private static final String D = "dddddddddddd";
    private static final String E = "eeeeeeeeeeee";
    private HgCache cache;
    private File dbFile;
    private static final String REPO_NAME = "test";
    @Mock
    private RepositoryConfig repoConfig;
    @Mock
    private HgContext repoContext;
    private RepositoryStatus repoStatus = new RepositoryStatus("test");

    @Before
    public void initCache() throws Exception {
        this.dbFile = File.createTempFile("topo-order-cs-iterator", ".db");
        if (this.dbFile.exists()) {
            this.dbFile.delete();
        }
        InfinityDbHandle dbHandle = new InfinityDbHandle(this.dbFile);
        Mockito.when((Object)this.repoConfig.getStatus()).thenReturn((Object)this.repoStatus);
        Mockito.when((Object)this.repoContext.getConfig()).thenReturn((Object)this.repoConfig);
        this.cache = new HgCache(99L, 99, this.repoContext, REPO_NAME, dbHandle, null, (LicenseEnforcer)new NullLicenseEnforcer(), null);
    }

    @After
    public void cleanUp() throws Exception {
        this.cache.getInfDb().close();
        if (!this.dbFile.delete()) {
            this.dbFile.deleteOnExit();
        }
    }

    protected HgChangeSet createCs(String csId, String ... parents) {
        HgChangeSet cs = new HgChangeSet(csId, this.cache.getChangeSetDAO(), this.cache.getFileRevisionDAO());
        cs.setBranch("branch");
        cs.setDate(System.currentTimeMillis());
        cs.setAuthor("author");
        cs.setComment("comment");
        if (parents.length > 0) {
            cs.setParents(Arrays.asList(parents));
        }
        return cs;
    }

    protected void createTestData() throws DbException, LicensePolicyException {
        HgChangeSet a = this.createCs(A, new String[0]);
        HgChangeSet b = this.createCs(B, A);
        HgChangeSet c = this.createCs(C, A, B);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)a);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)b);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)c);
    }

    protected void createTestDataWithLoop() throws DbException, LicensePolicyException {
        HgChangeSet a = this.createCs(A, new String[0]);
        HgChangeSet b = this.createCs(B, A);
        HgChangeSet c = this.createCs(C, A, B);
        HgChangeSet d = this.createCs(D, C, E);
        HgChangeSet e = this.createCs(E, C, D);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)a);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)b);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)c);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)d);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)e);
    }

    protected void assertIterationOrder(String ... csIds) {
        this.assertIterationOrder(false, csIds);
    }

    protected void assertIterationOrder(boolean useDateOrder, String ... csIds) {
        List<String> expected = Arrays.asList(csIds);
        TopologicalOrderChangesetIterator actualIt = new TopologicalOrderChangesetIterator((InternalRevisionCache)this.cache, useDateOrder);
        ArrayList<String> actual = new ArrayList<String>();
        Iterator<String> expectedIt = expected.iterator();
        while (actualIt.hasNext() && expectedIt.hasNext()) {
            MutableChangeSet cs = actualIt.next();
            Assert.assertNotNull((Object)cs);
            actual.add(cs.getId());
        }
        Assert.assertEquals((Object)expected.toString(), (Object)((Object)actual).toString());
    }

    @Test
    public void testAllChangeSetsInCreationOrder() throws DbException, LicensePolicyException {
        this.createTestData();
        this.assertIterationOrder(A, B, C);
    }

    @Test
    public void testAllChangeSetsInReverseOrder() throws DbException, LicensePolicyException {
        this.cache.getStringTables().changeSetIdDB.add(C);
        this.cache.getStringTables().changeSetIdDB.add(B);
        this.cache.getStringTables().changeSetIdDB.add(A);
        this.createTestData();
        this.assertIterationOrder(A, B, C);
    }

    @Test
    public void testAllChangeSetsInRandomOrder() throws DbException, LicensePolicyException {
        this.cache.getStringTables().changeSetIdDB.add(A);
        this.cache.getStringTables().changeSetIdDB.add(C);
        this.cache.getStringTables().changeSetIdDB.add(B);
        this.createTestData();
        this.assertIterationOrder(A, B, C);
    }

    @Test
    public void testAllChangeSetsWithLoop() throws DbException, LicensePolicyException {
        this.cache.getStringTables().changeSetIdDB.add(A);
        this.cache.getStringTables().changeSetIdDB.add(B);
        this.cache.getStringTables().changeSetIdDB.add(C);
        this.cache.getStringTables().changeSetIdDB.add(D);
        this.cache.getStringTables().changeSetIdDB.add(E);
        this.createTestDataWithLoop();
        this.assertIterationOrder(A, B, C, D, E);
    }

    @Test
    public void testAllChangeSetsWithLoopBackwards() throws DbException, LicensePolicyException {
        this.cache.getStringTables().changeSetIdDB.add(E);
        this.cache.getStringTables().changeSetIdDB.add(D);
        this.cache.getStringTables().changeSetIdDB.add(C);
        this.cache.getStringTables().changeSetIdDB.add(B);
        this.cache.getStringTables().changeSetIdDB.add(A);
        this.createTestDataWithLoop();
        this.assertIterationOrder(E, A, B, C, D);
    }

    @Test
    public void testAllChangeSetsWithFileRevs() throws DbException, LicensePolicyException {
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(A, "a.txt"), null, false);
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(A, "b.txt"), null, false);
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(C, "c.txt"), null, false);
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(D, "d.txt"), null, false);
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(E, "e.txt"), null, false);
        HgChangeSet a = this.createCs(A, new String[0]);
        HgChangeSet b = this.createCs(B, new String[0]);
        HgChangeSet c = this.createCs(C, new String[0]);
        HgChangeSet d = this.createCs(D, new String[0]);
        HgChangeSet e = this.createCs(E, new String[0]);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)a);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)b);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)c);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)d);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)e);
        this.assertIterationOrder(A, C, D, E, B);
    }

    @Test
    public void testAllChangeSetsWithFileRevsDateOrdered() throws DbException, LicensePolicyException {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(E, "e.txt", cal.getTime()), null, false);
        cal.add(10, -24);
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(D, "d.txt", cal.getTime()), null, false);
        cal.add(10, -24);
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(C, "c.txt", cal.getTime()), null, false);
        cal.add(10, -24);
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(A, "a.txt", cal.getTime()), null, false);
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(A, "b.txt", cal.getTime()), null, false);
        HgChangeSet a = this.createCs(A, new String[0]);
        HgChangeSet b = this.createCs(B, new String[0]);
        HgChangeSet c = this.createCs(C, new String[0]);
        HgChangeSet d = this.createCs(D, new String[0]);
        HgChangeSet e = this.createCs(E, new String[0]);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)a);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)b);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)c);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)d);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)e);
        this.assertIterationOrder(true, A, C, D, E, B);
        this.assertIterationOrder(false, E, D, C, A, B);
    }

    @Test
    public void testAllChangeSetsWithFileRevsAndPushBack() throws DbException, LicensePolicyException {
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(A, "a.txt"), null, false);
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(A, "b.txt"), null, false);
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(C, "c.txt"), null, false);
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(D, "d.txt"), null, false);
        this.cache.getFileRevisionDAO().insertNew(this.getFileRev(E, "e.txt"), null, false);
        HgChangeSet a = this.createCs(A, new String[0]);
        HgChangeSet b = this.createCs(B, new String[0]);
        HgChangeSet c = this.createCs(C, new String[0]);
        HgChangeSet d = this.createCs(D, new String[0]);
        HgChangeSet e = this.createCs(E, new String[0]);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)a);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)b);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)c);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)d);
        this.cache.getChangeSetDAO().store((ChangeSetImpl)e);
        TopologicalOrderChangesetIterator actualIt = new TopologicalOrderChangesetIterator((InternalRevisionCache)this.cache);
        Assert.assertTrue((boolean)actualIt.hasNext());
        MutableChangeSet cs = actualIt.next();
        Assert.assertEquals((Object)A, (Object)cs.getId());
        Assert.assertTrue((boolean)actualIt.hasNext());
        cs = actualIt.next();
        Assert.assertEquals((Object)C, (Object)cs.getId());
        cs.setParents((Iterable)Lists.newArrayList((Object[])new String[]{A, B}));
        actualIt.takeBack(cs);
        Assert.assertTrue((boolean)actualIt.hasNext());
        cs = actualIt.next();
        Assert.assertEquals((Object)B, (Object)cs.getId());
        cs.setParents((Iterable)Lists.newArrayList((Object[])new String[]{A}));
        Assert.assertTrue((boolean)actualIt.hasNext());
        cs = actualIt.next();
        Assert.assertEquals((Object)C, (Object)cs.getId());
        Assert.assertTrue((boolean)actualIt.hasNext());
        cs = actualIt.next();
        Assert.assertEquals((Object)D, (Object)cs.getId());
        cs.setParents((Iterable)Lists.newArrayList((Object[])new String[]{C, E}));
        actualIt.takeBack(cs);
        Assert.assertTrue((boolean)actualIt.hasNext());
        cs = actualIt.next();
        Assert.assertEquals((Object)E, (Object)cs.getId());
        cs.setParents((Iterable)Lists.newArrayList((Object[])new String[]{C, D}));
        actualIt.takeBack(cs);
        Assert.assertTrue((boolean)actualIt.hasNext());
        cs = actualIt.next();
        Assert.assertEquals((Object)E, (Object)cs.getId());
        Assert.assertTrue((boolean)actualIt.hasNext());
        cs = actualIt.next();
        Assert.assertEquals((Object)D, (Object)cs.getId());
        Assert.assertFalse((boolean)actualIt.hasNext());
    }

    private HgRevInfo getFileRev(String csid, String path) {
        return this.getFileRev(csid, path, new Date());
    }

    private HgRevInfo getFileRev(String csid, String path, Date date) {
        HgRevInfo rev = new HgRevInfo();
        rev.setRevision(csid);
        rev.setPath(new Path((CharSequence)path));
        rev.addBranch("default");
        rev.setDate(date.getTime());
        return rev;
    }
}

