/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.TagTreeVisitor;
import com.google.common.io.Files;
import com.infinitydb.Cu;
import com.infinitydb.CuAppendable;
import com.infinitydb.ItemSpace;
import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TagTreeVisitorTest {
    private InfinityDbHandle handle;
    private ItemSpace db;
    private TagTreeVisitor tagTreeVisitor;

    @Before
    public void setUp() throws Exception {
        File dbFile = new File(Files.createTempDir(), "output/tagtreevisitor.idb");
        this.handle = new InfinityDbHandle(dbFile);
        this.db = this.handle.get();
        this.tagTreeVisitor = new TagTreeVisitor(this.db);
    }

    @After
    public void tearDown() throws Exception {
        this.handle.close();
    }

    private void populateDb(Cu cu) throws IOException {
        cu.clear();
        cu.append((CuAppendable)CommonSchema.RevInfo.ENTITY).append(5L);
        cu.append((CuAppendable)CommonSchema.RevInfo.A_SUCCESSOR).append(4L);
        this.db.insert(cu);
        cu.clear();
        cu.append((CuAppendable)CommonSchema.RevInfo.ENTITY).append(4L);
        cu.append((CuAppendable)CommonSchema.RevInfo.A_SUCCESSOR).append(3L);
        this.db.insert(cu);
        cu.clear();
        cu.append((CuAppendable)CommonSchema.RevInfo.ENTITY).append(3L);
        cu.append((CuAppendable)CommonSchema.RevInfo.A_SUCCESSOR).append(2L);
        this.db.insert(cu);
        cu.clear();
        cu.append((CuAppendable)CommonSchema.RevInfo.ENTITY).append(7L);
        cu.append((CuAppendable)CommonSchema.RevInfo.A_SUCCESSOR).append(5L);
        this.db.insert(cu);
        cu.clear();
        cu.append((CuAppendable)CommonSchema.RevInfo.ENTITY).append(12L);
        cu.append((CuAppendable)CommonSchema.RevInfo.A_SUCCESSOR).append(9L);
        this.db.insert(cu);
        cu.clear();
        cu.append((CuAppendable)CommonSchema.RevInfo.ENTITY).append(9L);
        cu.append((CuAppendable)CommonSchema.RevInfo.A_SUCCESSOR).append(8L);
        this.db.insert(cu);
    }

    @Test
    public void testFindLastSuccessor() throws Exception {
        Cu cu = Cu.alloc();
        this.populateDb(cu);
        Assert.assertEquals((long)2L, (long)this.tagTreeVisitor.findLastSuccessor(5));
        Assert.assertEquals((long)2L, (long)this.tagTreeVisitor.findLastSuccessor(4));
        Assert.assertEquals((long)2L, (long)this.tagTreeVisitor.findLastSuccessor(3));
        Assert.assertEquals((long)2L, (long)this.tagTreeVisitor.findLastSuccessor(7));
        Assert.assertEquals((long)8L, (long)this.tagTreeVisitor.findLastSuccessor(12));
        Assert.assertEquals((long)8L, (long)this.tagTreeVisitor.findLastSuccessor(9));
        Assert.assertEquals((long)90L, (long)this.tagTreeVisitor.findLastSuccessor(90));
        Assert.assertEquals((long)91L, (long)this.tagTreeVisitor.findLastSuccessor(91));
        Assert.assertEquals((long)92L, (long)this.tagTreeVisitor.findLastSuccessor(92));
    }

    @Test
    public void testFindNextSuccessor() throws Exception {
        Cu cu = Cu.alloc();
        this.populateDb(cu);
        Assert.assertEquals((long)4L, (long)this.tagTreeVisitor.findNextSuccessor(5));
        Assert.assertEquals((long)3L, (long)this.tagTreeVisitor.findNextSuccessor(4));
        Assert.assertEquals((long)2L, (long)this.tagTreeVisitor.findNextSuccessor(3));
        Assert.assertEquals((long)5L, (long)this.tagTreeVisitor.findNextSuccessor(7));
        Assert.assertEquals((long)9L, (long)this.tagTreeVisitor.findNextSuccessor(12));
        Assert.assertEquals((long)8L, (long)this.tagTreeVisitor.findNextSuccessor(9));
        Assert.assertEquals((long)90L, (long)this.tagTreeVisitor.findNextSuccessor(90));
        Assert.assertEquals((long)91L, (long)this.tagTreeVisitor.findNextSuccessor(91));
        Assert.assertEquals((long)92L, (long)this.tagTreeVisitor.findNextSuccessor(92));
    }
}

