/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fecru.user.FecruUser;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.CrucibleRevision;
import com.cenqua.crucible.model.FileRevisionExtraInfo;
import com.cenqua.crucible.model.Project;
import com.cenqua.crucible.model.Review;
import com.cenqua.crucible.model.managers.FileRevisionManager;
import com.cenqua.crucible.model.managers.ReviewManager;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.dbutils.ModelUtils;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.TestFishEyeInstances;
import com.cenqua.fisheye.search.SearchResults;
import com.cenqua.fisheye.search.query.FishQuery;
import com.cenqua.fisheye.util.Disposer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public final class ReviewInfoDAOTest {
    private ReviewManager reviewManager;

    @Before
    public void setUp() throws Exception {
        TestFishEyeInstances.checkCleanStart();
        TestFishEyeInstances.deleteData0();
        TestFishEyeInstances.deleteCruDB();
        TestFishEyeInstances.loadSanity1();
        Disposer.pushThreadInstance();
        TestFishEyeInstances.getSanity1Repos().requestCrucibleReindex(true);
        this.reviewManager = DefaultReviewManager.get();
    }

    @After
    public void tearDown() throws Exception {
        Disposer.popThreadInstance();
        HibernateUtil.commitTransaction();
        HibernateUtil.closeSession();
        TestFishEyeInstances.stop();
    }

    @Test
    public void testDiffFileStuff() throws Exception {
        HibernateUtil.beginTransaction();
        RepositoryHandle handle = TestFishEyeInstances.getSanity1Repos();
        FecruUser joe = ModelUtils.makeAndSaveUser("joe");
        Project defaultProject = ModelUtils.getProjectManager().getDefaultProject();
        Review r1 = this.reviewManager.createReview(ModelUtils.getProjectManager(), defaultProject, "review 1", joe);
        CrucibleRevision cr88 = FileRevisionManager.createRevision((String)"cvs", (String)"test/test.text", (String)"1.88", (String)"1.88", (Date)new Date());
        CrucibleRevision cr87 = FileRevisionManager.createRevision((String)"cvs", (String)"test/test.text", (String)"1.87", (String)"1.87", (Date)new Date());
        CrucibleRevision cr86 = FileRevisionManager.createRevision((String)"cvs", (String)"test/test.text", (String)"1.86", (String)"1.86", (Date)new Date());
        FileRevisionExtraInfo frx = r1.addRevision(cr86);
        frx.addRevision(1, cr87);
        frx.setShowAsDiff(Boolean.valueOf(true));
        HibernateUtil.bounceTransaction();
        handle.oneOffScan(true);
        this.assertReviewState(r1.getId(), false, true, false);
        frx.addRevision(2, cr88);
        frx.removeRevision(cr86);
        HibernateUtil.bounceTransaction();
        handle.oneOffScan(true);
        this.assertReviewState(r1.getId(), false, false, true);
        frx.addRevision(0, cr86);
        HibernateUtil.bounceTransaction();
        handle.oneOffScan(true);
        this.assertReviewState(r1.getId(), false, true, true);
        handle.requestCrucibleReindex(true);
        this.assertReviewState(r1.getId(), false, true, true);
        frx.setShowAsDiff(Boolean.valueOf(false));
        HibernateUtil.bounceTransaction();
        handle.oneOffScan(true);
        this.assertReviewState(r1.getId(), true, true, true);
        r1.removeFRX(frx);
        HibernateUtil.bounceTransaction();
        handle.oneOffScan(true);
        this.assertReviewState(r1.getId(), false, false, false);
    }

    @Test
    public void testWholeFileStuff() throws Exception {
        HibernateUtil.beginTransaction();
        RepositoryHandle handle = TestFishEyeInstances.getSanity1Repos();
        FecruUser joe = ModelUtils.makeAndSaveUser("joe");
        Project defaultProject = ModelUtils.getProjectManager().getDefaultProject();
        Review r1 = this.reviewManager.createReview(ModelUtils.getProjectManager(), defaultProject, "review 1", joe);
        CrucibleRevision cr88 = FileRevisionManager.createRevision((String)"cvs", (String)"test/test.text", (String)"1.88", (String)"1.88", (Date)new Date());
        CrucibleRevision cr87 = FileRevisionManager.createRevision((String)"cvs", (String)"test/test.text", (String)"1.87", (String)"1.87", (Date)new Date());
        CrucibleRevision cr86 = FileRevisionManager.createRevision((String)"cvs", (String)"test/test.text", (String)"1.86", (String)"1.86", (Date)new Date());
        FileRevisionExtraInfo frx = r1.addRevision(cr86);
        frx.setShowAsDiff(Boolean.valueOf(false));
        HibernateUtil.bounceTransaction();
        handle.oneOffScan(true);
        this.assertReviewState(r1.getId(), true, false, false);
        frx.addRevision(1, cr87);
        HibernateUtil.bounceTransaction();
        handle.oneOffScan(true);
        this.assertReviewState(r1.getId(), true, true, false);
        frx.removeRevision(cr86);
        HibernateUtil.bounceTransaction();
        handle.oneOffScan(true);
        this.assertReviewState(r1.getId(), false, true, false);
        frx.addRevision(0, cr86);
        HibernateUtil.bounceTransaction();
        handle.oneOffScan(true);
        this.assertReviewState(r1.getId(), true, true, false);
        frx.addRevision(2, cr88);
        HibernateUtil.bounceTransaction();
        handle.oneOffScan(true);
        this.assertReviewState(r1.getId(), true, true, true);
        frx.setShowAsDiff(Boolean.valueOf(true));
        HibernateUtil.bounceTransaction();
        handle.oneOffScan(true);
        this.assertReviewState(r1.getId(), false, true, true);
        handle.requestCrucibleReindex(true);
        this.assertReviewState(r1.getId(), false, true, true);
        r1.removeFRX(frx);
        HibernateUtil.bounceTransaction();
        handle.oneOffScan(true);
        this.assertReviewState(r1.getId(), false, false, false);
    }

    private void assertReviewState(Integer reviewid, boolean r86, boolean r87, boolean r88) throws Exception {
        RevInfoKey rik86 = new RevInfoKey(new Path((CharSequence)"test/test.text"), "1.86");
        RevInfoKey rik87 = new RevInfoKey(new Path((CharSequence)"test/test.text"), "1.87");
        RevInfoKey rik88 = new RevInfoKey(new Path((CharSequence)"test/test.text"), "1.88");
        RepositoryEngine engine = TestFishEyeInstances.getSanity1Repos().acquireEngine();
        ArrayList<RevInfoKey> expectedRevisions = new ArrayList<RevInfoKey>();
        if (r86) {
            expectedRevisions.add(rik86);
            this.assertContainsReviews(rik86, reviewid);
        } else {
            this.assertContainsReviews(rik86, new Integer[0]);
        }
        if (r87) {
            expectedRevisions.add(rik87);
            this.assertContainsReviews(rik87, reviewid);
        } else {
            this.assertContainsReviews(rik87, new Integer[0]);
        }
        if (r88) {
            expectedRevisions.add(rik88);
            this.assertContainsReviews(rik88, reviewid);
        } else {
            this.assertContainsReviews(rik88, new Integer[0]);
        }
        FishQuery fq = FishQuery.parse((String)"select revisions where in any draft review", new ArrayList());
        SearchResults results = engine.getSearchManager().runQuery(fq, true);
        ArrayList<RevInfoKey> foundRevisions = new ArrayList<RevInfoKey>();
        SearchResults.RevisionResultsIterator i = results.iterateRevisions(0);
        while (i.hasNext()) {
            foundRevisions.add(i.nextItem().getRevInfoKey());
        }
        Assert.assertEquals((int)expectedRevisions.size(), (int)foundRevisions.size());
        Assert.assertTrue((boolean)expectedRevisions.containsAll(foundRevisions));
        Assert.assertTrue((boolean)foundRevisions.containsAll(expectedRevisions));
    }

    private void assertContainsReviews(RevInfoKey rik, Integer ... reviews) throws Exception {
        RepositoryEngine engine = TestFishEyeInstances.getSanity1Repos().acquireEngine();
        RevisionCache cache = engine.getRevisionCache();
        FileRevision fr = cache.getFileRevision(rik);
        ArrayList ids = new ArrayList(fr.getReviewIds());
        Assert.assertEquals((int)reviews.length, (int)ids.size());
        List<Integer> expected = Arrays.asList(reviews);
        Assert.assertTrue((boolean)ids.containsAll(expected));
        Assert.assertTrue((boolean)expected.containsAll(ids));
    }
}

