/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fecru.util.ClassUtils;
import com.atlassian.fisheye.db.FileRevisionDAO;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.rep.impl.LazyFileRevisionInterceptor;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.NoOp;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class LazyLoadingFileRevisionHandlerTest {
    private FileRevisionDAO mockDAO;
    private MyFileRevision proxy;

    @Before
    public void setup() throws Exception {
        this.mockDAO = (FileRevisionDAO)Mockito.mock(FileRevisionDAO.class);
        LazyFileRevisionInterceptor callback = new LazyFileRevisionInterceptor(100, this.mockDAO);
        Factory f = ClassUtils.createEnhancer(MyFileRevision.class, (Callback)callback);
        this.proxy = (MyFileRevision)((Object)f.newInstance(new Callback[]{callback, NoOp.INSTANCE}));
    }

    @Test
    public void testGetRevID() {
        Assert.assertEquals((long)100L, (long)this.proxy.getRevID());
        Assert.assertEquals((long)100L, (long)this.proxy.getRevID());
        Assert.assertEquals((long)100L, (long)this.proxy.getRevID());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockDAO});
    }

    @Test
    public void testTriggerGetKey() throws DbException {
        RevInfoKey key = new RevInfoKey(new Path((CharSequence)"bla"), "revision");
        Mockito.when((Object)this.mockDAO.getKey(100)).thenReturn((Object)key).thenThrow(new Throwable[]{new IllegalStateException()});
        Assert.assertEquals((Object)key, (Object)this.proxy.getRevInfoKey());
        Assert.assertEquals((Object)key, (Object)this.proxy.getRevInfoKey());
        Assert.assertEquals((Object)key, (Object)this.proxy.getRevInfoKey());
    }

    @Test
    public void testTriggerLoadFileRevision() throws DbException {
        MyFileRevision completeRevision = new MyFileRevision();
        completeRevision.setComment("comment");
        Mockito.when((Object)this.mockDAO.load(100)).thenReturn((Object)completeRevision).thenThrow(new Throwable[]{new IllegalStateException()});
        Assert.assertEquals((Object)"comment", (Object)this.proxy.getComment());
        Assert.assertEquals((Object)"comment", (Object)this.proxy.getComment());
        Assert.assertEquals((Object)"comment", (Object)this.proxy.getComment());
    }

    @Test
    public void testGetAncestors() throws Exception {
        RevInfoKey key1 = new RevInfoKey();
        RevInfoKey key2 = new RevInfoKey();
        RevInfoKey key3 = new RevInfoKey();
        Mockito.when((Object)this.mockDAO.getAncestorLink(100)).thenReturn((Object)new AncestorLink(AncestorLink.Type.BRANCHPOINT, new int[]{1, 2, 10})).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)this.mockDAO.getKey(1)).thenReturn((Object)key1).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)this.mockDAO.getKey(2)).thenReturn((Object)key2).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)this.mockDAO.getKey(10)).thenReturn((Object)key3).thenThrow(new Throwable[]{new IllegalStateException()});
        List ancestors = this.proxy.getAncestors();
        this.proxy.getAncestors();
        Assert.assertThat((Object)ancestors, (Matcher)Matchers.contains((Matcher[])new Matcher[]{Matchers.sameInstance((Object)key1), Matchers.sameInstance((Object)key2), Matchers.sameInstance((Object)key3)}));
    }

    @Test
    public void testGetLogicalPath() throws Exception {
        Path illogicalPath = new Path((CharSequence)"bla");
        Path logicalPath = new Path((CharSequence)"logicalBla");
        RevInfoKey key = new RevInfoKey(illogicalPath, "revision");
        Mockito.when((Object)this.mockDAO.getKey(100)).thenReturn((Object)key).thenThrow(new Throwable[]{new IllegalStateException()});
        Mockito.when((Object)this.mockDAO.getLogicalPath(illogicalPath)).thenReturn((Object)logicalPath).thenThrow(new Throwable[]{new IllegalStateException()});
        Path result = this.proxy.getLogicalPath();
        this.proxy.getLogicalPath();
        Assert.assertEquals((Object)logicalPath, (Object)result);
    }

    public static class MyFileRevision
    extends CommonFileRevision {
        private boolean finalized = false;

        public void finalize() {
            this.finalized = true;
        }

        public boolean isFinalizedCalled() {
            return this.finalized;
        }
    }
}

