/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.FisheyeTestUtil;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import java.util.Collections;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class CommonRevInfoDAOTest {
    CommonRevInfoDAO dao;
    InfinityDbHandle handle;

    @Before
    public void setUp() throws Exception {
        this.handle = FisheyeTestUtil.createTempDBHandleForWrite();
        this.dao = new CommonRevInfoDAO(this.handle, new CommonStringTables((UniqueStringTableFactory)this.handle), false, true, (LicenseEnforcer)Mockito.mock(LicenseEnforcer.class));
    }

    @After
    public void tearDown() throws Exception {
        this.handle.close();
    }

    @Test
    public void testHasBlameSpans() throws Exception {
        this.dao.setBlameSpans(1, Collections.singletonList(new BlameChunk(0, 0, 5, 1)));
        this.dao.setBlameSpans(2, Collections.emptyList());
        boolean hasSpansWithItems = this.dao.hasBlameSpans(1);
        boolean hasSpansWithoutItems = this.dao.hasBlameSpans(2);
        boolean hasNoSpans = this.dao.hasBlameSpans(3);
        Assert.assertTrue((boolean)hasSpansWithItems);
        Assert.assertTrue((boolean)hasSpansWithoutItems);
        Assert.assertFalse((boolean)hasNoSpans);
    }
}

