/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class CommonFileRevisionTest {
    @Test
    public void testIsNotMetdataChangeIfLinesAdded() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        TestFileRevision revision = CommonFileRevisionTest.newModifiedRevision();
        revision.setLinesAdded(1);
        Assert.assertFalse((boolean)revision.isMetadataOnlyChange());
    }

    @Test
    public void testIsNotMetadataChangeIfLinesRemoved() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        TestFileRevision revision = CommonFileRevisionTest.newModifiedRevision();
        revision.setLinesRemoved(1);
        Assert.assertFalse((boolean)revision.isMetadataOnlyChange());
    }

    @Test
    public void testIsNotMetadataChangeIfLinesAddedAndRemoved() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        TestFileRevision revision = CommonFileRevisionTest.newModifiedRevision();
        revision.setLinesAdded(1);
        revision.setLinesRemoved(1);
        Assert.assertFalse((boolean)revision.isMetadataOnlyChange());
    }

    @Test
    public void testIsMetadataChangeIfNoLinesChanged() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        Assert.assertTrue((boolean)CommonFileRevisionTest.newModifiedRevision().isMetadataOnlyChange());
    }

    @Test
    public void testIsNotMetadataChangeIfNoLinesChangedButSysPropSet() {
        boolean original = CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES;
        CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES = false;
        try {
            Assert.assertFalse((boolean)CommonFileRevisionTest.newModifiedRevision().isMetadataOnlyChange());
        }
        finally {
            CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES = original;
        }
    }

    @Test
    public void testIsNotMetadataChangeIfAdded() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        Assert.assertFalse((boolean)CommonFileRevisionTest.newAddedRevision().isMetadataOnlyChange());
    }

    @Test
    public void testIsNotMetadataChangeIfDeleted() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        Assert.assertFalse((boolean)CommonFileRevisionTest.newDeletedRevision().isMetadataOnlyChange());
    }

    @Test
    public void testIsNotMetadataChangeIfBinary() {
        Assume.assumeTrue((boolean)CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES);
        Assert.assertFalse((boolean)CommonFileRevisionTest.newBinaryRevision().isMetadataOnlyChange());
    }

    public static TestFileRevision newModifiedRevision() {
        TestFileRevision revision = new TestFileRevision();
        revision.setBinary(false);
        revision.setAdded(false);
        revision.setDead(false);
        revision.setCopy(false);
        revision.setModify(true);
        return revision;
    }

    public static TestFileRevision newBinaryRevision() {
        TestFileRevision revision = new TestFileRevision();
        revision.setBinary(true);
        revision.setAdded(false);
        revision.setDead(false);
        revision.setCopy(false);
        revision.setModify(false);
        return revision;
    }

    public static TestFileRevision newDeletedRevision() {
        TestFileRevision revision = new TestFileRevision();
        revision.setBinary(true);
        revision.setAdded(false);
        revision.setDead(true);
        revision.setCopy(false);
        revision.setModify(false);
        return revision;
    }

    public static TestFileRevision newAddedRevision() {
        TestFileRevision revision = new TestFileRevision();
        revision.setBinary(false);
        revision.setAdded(true);
        revision.setDead(false);
        revision.setCopy(false);
        revision.setModify(false);
        return revision;
    }

    public static class TestFileRevision
    extends CommonFileRevision {
    }
}

