/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fisheye.db.FileRevisionDAO;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.impl.ChangeSetDAO;
import com.cenqua.fisheye.rep.impl.CommonChangeSetDAO;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommonChangeSetDAOUnitTest {
    private CommonChangeSetDAO dao;
    private static List<String> csIdsThatExist = ImmutableList.of((Object)"B", (Object)"F", (Object)"G", (Object)"H", (Object)"F1", (Object)"H1", (Object)"F1", (Object)"D1");
    private static ImmutableMultimap<String, String> csidParents = ImmutableMultimap.builder().put((Object)"I", (Object)"H").put((Object)"I", (Object)"H1").put((Object)"I", (Object)"H2").put((Object)"H1", (Object)"G").put((Object)"H2", (Object)"G").put((Object)"H", (Object)"G").put((Object)"G", (Object)"F").put((Object)"F1", (Object)"E1").put((Object)"F", (Object)"E").put((Object)"E", (Object)"D").put((Object)"E1", (Object)"D").put((Object)"E1", (Object)"D1").put((Object)"D1", (Object)"C1").put((Object)"C1", (Object)"B").put((Object)"C1", (Object)"Z").put((Object)"D", (Object)"C").put((Object)"C", (Object)"B").put((Object)"B", (Object)"A").put((Object)"A", (Object)"Z").build();

    @Before
    public void setUp() throws Exception {
        this.dao = new ResolveParentChangesetDAO();
    }

    @Test
    public void testResolveParent_parentExists() throws Exception {
        Assert.assertThat(this.resolveParents("H"), (Matcher)Matchers.contains((Object[])new String[]{"H"}));
        Assert.assertThat(this.resolveParents("G"), (Matcher)Matchers.contains((Object[])new String[]{"G"}));
        Assert.assertThat(this.resolveParents("F"), (Matcher)Matchers.contains((Object[])new String[]{"F"}));
    }

    @Test
    public void testResolveParent_parentDoesntExist() throws Exception {
        Assert.assertThat(this.resolveParents("E"), (Matcher)Matchers.contains((Object[])new String[]{"B"}));
        Assert.assertThat(this.resolveParents("D"), (Matcher)Matchers.contains((Object[])new String[]{"B"}));
        Assert.assertThat(this.resolveParents("C"), (Matcher)Matchers.contains((Object[])new String[]{"B"}));
        Assert.assertThat(this.resolveParents("B"), (Matcher)Matchers.contains((Object[])new String[]{"B"}));
    }

    @Test
    public void testResolveParent_noParent() throws Exception {
        Assert.assertThat(this.resolveParents("A"), (Matcher)Matchers.emptyIterable());
    }

    @Test
    public void testResolveParent_multipleParents() throws Exception {
        Assert.assertThat(this.resolveParents("I"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"H", "H1", "G"}));
        Assert.assertThat(this.resolveParents("E1"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"B", "D1"}));
        Assert.assertThat(this.resolveParents("C1"), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"B"}));
    }

    @Test
    public void testIterateAncestors() throws Exception {
        ImmutableList ancestorsOfI = ImmutableList.copyOf((Iterator)this.dao.iterateAncestors("I"));
        ImmutableList ancestorsOfF1 = ImmutableList.copyOf((Iterator)this.dao.iterateAncestors("F1"));
        Assert.assertThat((Object)ancestorsOfI, (Matcher)Matchers.contains((Object[])new String[]{"H", "H1", "G", "F", "B"}));
        Assert.assertThat((Object)ancestorsOfF1, (Matcher)Matchers.contains((Object[])new String[]{"F1", "D1", "B"}));
    }

    @Test
    public void testIterateDescendants() throws Exception {
        ImmutableList descendantsOfD = ImmutableList.copyOf((Iterator)this.dao.iterateDescendants("D"));
        ImmutableList descendantsOfB = ImmutableList.copyOf((Iterator)this.dao.iterateDescendants("B"));
        ImmutableList descendantsOfH2 = ImmutableList.copyOf((Iterator)this.dao.iterateDescendants("H2"));
        ImmutableList descendantsOfF1 = ImmutableList.copyOf((Iterator)this.dao.iterateDescendants("F1"));
        Assert.assertThat((Object)descendantsOfD, (Matcher)Matchers.contains((Object[])new String[]{"F", "F1", "G", "H1", "H"}));
        Assert.assertThat((Object)descendantsOfB, (Matcher)Matchers.contains((Object[])new String[]{"B", "D1", "F1", "F", "G", "H1", "H"}));
        Assert.assertThat((Object)descendantsOfH2, (Matcher)Matchers.empty());
        Assert.assertThat((Object)descendantsOfF1, (Matcher)Matchers.contains((Object[])new String[]{"F1"}));
    }

    private Collection<String> resolveParents(String parentCsId) {
        return this.dao.resolveParent(parentCsId);
    }

    private static class ResolveParentChangesetDAO
    extends MyChangeSetDAO {
        public ResolveParentChangesetDAO() {
            super(null, null, null, null);
        }

        public boolean exists(String csid) {
            return csIdsThatExist.contains(csid);
        }

        public List<String> loadParentIds(String parentId) {
            return ImmutableList.copyOf((Collection)csidParents.get((Object)parentId));
        }

        public List<String> loadChildIds(String csId) throws DbException {
            return ImmutableList.copyOf((Collection)csidParents.inverse().get((Object)csId));
        }
    }

    private static class MyChangeSetDAO
    extends CommonChangeSetDAO<FileRevision, MyChangeSet, CommonStringTables> {
        public MyChangeSetDAO(InfinityDbHandle dbh, CommonStringTables stringTables, FileRevisionDAO<FileRevision> fileRevDAO, LicenseEnforcer lm) {
            super(null, dbh, stringTables, fileRevDAO, lm);
        }

        public MyChangeSet createChangeSet(String csid) {
            return new MyChangeSet(csid, (ChangeSetDAO<FileRevision, MyChangeSet>)this, null);
        }
    }

    private static class MyChangeSet
    extends ChangeSetImpl<FileRevision> {
        protected MyChangeSet() {
        }

        public MyChangeSet(String csid, ChangeSetDAO<FileRevision, MyChangeSet> csDao, FileRevisionDAO<FileRevision> dao) {
            super(csid, csDao, dao);
        }

        public int compareSecondarySort(ChangeSet bound) {
            return 0;
        }

        public Set<Integer> getReviewIds() throws DbException {
            return null;
        }

        public String toString() {
            return this.getId();
        }
    }
}

