/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.db.CommonBranchDAO;
import com.atlassian.fisheye.db.FileRevisionDAO;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTableFactory;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetImpl;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.ChangeSetDAO;
import com.cenqua.fisheye.rep.impl.CommonChangeSetDAO;
import com.cenqua.fisheye.rep.impl.CommonSchema;
import com.cenqua.fisheye.rep.impl.CommonStringTables;
import com.cenqua.fisheye.rep.impl.NullLicenseEnforcer;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.infinitydb.Cu;
import com.infinitydb.CuAppendable;
import com.infinitydb.ItemSpace;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommonChangeSetDAOTest {
    private static final String REPO_NAME = "testrepo";
    private File dbFile;
    private InfinityDbHandle dbHandle;
    private CommonChangeSetDAO<FileRevision, MyChangeSet, CommonStringTables> csDAO;
    private FileRevisionDAO<FileRevision> fileRevDAOMock;
    private LicenseEnforcer dummyLm = new NullLicenseEnforcer();
    private CommonBranchDAO branchDAO;

    @Before
    public void setup() throws IOException {
        this.dbFile = File.createTempFile("commoncstest", ".db");
        if (this.dbFile.exists()) {
            this.dbFile.delete();
        }
        this.dbHandle = new InfinityDbHandle(this.dbFile);
        this.fileRevDAOMock = (FileRevisionDAO)EasyMock.createMock(FileRevisionDAO.class);
        EasyMock.expect((Object)this.fileRevDAOMock.getRepName()).andReturn((Object)REPO_NAME).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.fileRevDAOMock});
        CommonStringTables stringTables = new CommonStringTables((UniqueStringTableFactory)this.dbHandle);
        this.csDAO = new MyChangeSetDAO(this.dbHandle, stringTables, this.fileRevDAOMock, this.dummyLm);
        this.branchDAO = new CommonBranchDAO(this.dbHandle, stringTables);
    }

    @After
    public void teardown() throws Exception {
        this.dbHandle.close();
        if (!this.dbFile.delete()) {
            this.dbFile.deleteOnExit();
        }
    }

    @Test
    public void testChangeSetsInStateShouldSkipNullObjects() throws Exception {
        String csIdNull = "changeset-id";
        String csIdNotNull = "changeset-not-null-id";
        MyChangeSet csNull = this.createChangeSet("changeset-id", "author", "comment", new GregorianCalendar(2010, 7, 12));
        this.csDAO.store((ChangeSetImpl)csNull);
        this.csDAO.setIndexingState("changeset-id", ChangeSetIndexingState.COMPLETE);
        MyChangeSet csNotNull = this.createChangeSet("changeset-not-null-id", "author", "comment", new GregorianCalendar(2015, 3, 9));
        this.csDAO.store((ChangeSetImpl)csNotNull);
        this.csDAO.setIndexingState("changeset-not-null-id", ChangeSetIndexingState.COMPLETE);
        this.removeChangeSet("changeset-id");
        ArrayList result = Lists.newArrayList((Iterable)this.csDAO.getChangeSetsInState(ChangeSetIndexingState.COMPLETE));
        Collection resultIds = Collections2.transform((Collection)result, (Function)new Function<ChangeSet, String>(){

            public String apply(ChangeSet changeSet) {
                return changeSet == null ? "NOT VALID CHANGESET" : changeSet.getId();
            }
        });
        Assert.assertThat((String)"Given iterable should contains only not null changesets", (Object)resultIds, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"changeset-not-null-id"}));
    }

    private void removeChangeSet(String csIdNull) throws IOException {
        long csNullId = this.csDAO.stringTables.changeSetIdDB.find(csIdNull);
        this.csDAO.makeEav(csNullId).deleteEntity();
    }

    @Test
    public void testGetAllAuthorsConcurrently() throws Exception {
        ItemSpace db = this.dbHandle.get();
        Cu cu = Cu.alloc();
        int AUTHOR_COUNT = 1000;
        for (long i = 0L; i < 1000L; ++i) {
            cu.append((CuAppendable)CommonSchema.E_AUTHOR_TO_REVID);
            String authString = "auth" + i;
            cu.append(authString);
            cu.append(authString);
            db.insert(cu);
            cu.clear();
        }
        Cu.dispose((Cu)cu);
        int THREAD_COUNT = 20;
        int WAIT_TIMEOUT = 15;
        CountDownLatch start = new CountDownLatch(20);
        CountDownLatch end = new CountDownLatch(20);
        AtomicReference<Object> exception = new AtomicReference<Object>(null);
        for (int i = 0; i < 20; ++i) {
            new Thread(() -> {
                try {
                    start.await(15L, TimeUnit.SECONDS);
                    this.csDAO.getAllAuthors();
                }
                catch (Throwable throwable) {
                    exception.compareAndSet(null, throwable);
                }
                finally {
                    end.countDown();
                }
            }).start();
            start.countDown();
        }
        end.await(15L, TimeUnit.SECONDS);
        Throwable foundThrowable = exception.get();
        if (foundThrowable != null) {
            StringBuilder stacktrace = new StringBuilder().append("error executing CommonChangeSetDAO.getAllAuthors() : ").append(foundThrowable.toString()).append(" : ");
            for (StackTraceElement stackTraceElement : foundThrowable.getStackTrace()) {
                stacktrace.append("\n\tat ").append(stackTraceElement.toString());
            }
            Assert.fail((String)stacktrace.append("\nFound error at:").toString());
        }
    }

    @Test
    public void testStoreAndLoadNoFileRevisions() throws Exception {
        MyChangeSet cs = this.createChangeSet("changeset-id", "author", "comment", new GregorianCalendar(2010, 7, 12));
        cs.setBranches(Arrays.asList("branch1", "branch2"));
        this.csDAO.store((ChangeSetImpl)cs);
        MyChangeSet loadedCs = (MyChangeSet)this.csDAO.load(cs.getId());
        Assert.assertEquals((Object)cs.getAuthor(), (Object)loadedCs.getAuthor());
        Assert.assertEquals((Object)cs.getComment(), (Object)loadedCs.getComment());
        Assert.assertEquals((long)cs.getDate(), (long)loadedCs.getDate());
        Assert.assertEquals((Object)cs.getBranches(), (Object)loadedCs.getBranches());
        Assert.assertEquals((Object)REPO_NAME, (Object)loadedCs.getRepName());
        EasyMock.verify((Object[])new Object[]{this.fileRevDAOMock});
    }

    @Test
    public void testLazyLoadFileRevisions() throws Exception {
        MyChangeSet cs = this.createChangeSet("changeset-id", "author", "comment", new GregorianCalendar(2010, 7, 12));
        cs.setBranches(Arrays.asList("branch1", "branch2"));
        EasyMock.reset((Object[])new Object[]{this.fileRevDAOMock});
        this.fileRevDAOMock.visitChangeSetRevisions((String)EasyMock.eq((Object)cs.getId()), (StoppableVisitor)EasyMock.anyObject());
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.fileRevDAOMock});
        this.csDAO.store((ChangeSetImpl)cs);
        MyChangeSet loadedCs = (MyChangeSet)this.csDAO.load(cs.getId());
        List revisions = loadedCs.getFileRevisions();
        List secondLoad = loadedCs.getFileRevisions();
        Assert.assertNotNull((Object)revisions);
        Assert.assertNotNull((Object)secondLoad);
        EasyMock.verify((Object[])new Object[]{this.fileRevDAOMock});
    }

    @Test
    public void testBranchManagement() throws DbException, LicensePolicyException {
        MyChangeSet cs1 = this.createChangeSet("cs1", "jack", "Comment 1", new GregorianCalendar(2011, 3, 6));
        MyChangeSet cs2 = this.createChangeSet("cs2", "jack", "Comment 2", new GregorianCalendar(2011, 3, 7));
        MyChangeSet cs3 = this.createChangeSet("cs3", "jack", "Comment 3", new GregorianCalendar(2011, 3, 8));
        this.csDAO.store((ChangeSetImpl)cs1);
        this.csDAO.store((ChangeSetImpl)cs2);
        this.csDAO.store((ChangeSetImpl)cs3);
        Assert.assertTrue((String)"cs1 should have no branch", (boolean)((MyChangeSet)this.csDAO.load("cs1")).getBranches().isEmpty());
        this.csDAO.markAsAncestorOfBranch("cs1", "br1");
        this.csDAO.markAsAncestorOfBranch("cs2", "br1");
        this.csDAO.markAsAncestorOfBranch("cs2", "br2");
        this.csDAO.markAsAncestorOfBranch("cs3", "br1");
        Assert.assertTrue((String)"cs1 should have branch br1", (boolean)((MyChangeSet)this.csDAO.load("cs1")).getBranchesContributedTo().equals(Collections.singleton("br1")));
        Assert.assertTrue((String)"cs3 should have branch br1", (boolean)((MyChangeSet)this.csDAO.load("cs3")).getBranchesContributedTo().equals(Collections.singleton("br1")));
        HashSet<String> branchSet = new HashSet<String>();
        branchSet.addAll(Arrays.asList("br1", "br2"));
        Assert.assertTrue((String)"cs2 should have branch br1", (boolean)((MyChangeSet)this.csDAO.load("cs2")).getBranchesContributedTo().equals(branchSet));
        ListIterator iterator = this.csDAO.getChangeSetsInAncestryOfBranch("br1").iterator();
        Assert.assertEquals((String)"cs1 on branch not where expected", (Object)"cs1", (Object)((MyChangeSet)((Object)iterator.next())).getId());
        Assert.assertEquals((String)"cs2 on branch not where expected", (Object)"cs2", (Object)((MyChangeSet)((Object)iterator.next())).getId());
        Assert.assertEquals((String)"cs3 on branch not where expected", (Object)"cs3", (Object)((MyChangeSet)((Object)iterator.next())).getId());
        Assert.assertFalse((String)"Unexpected changeset element on br1", (boolean)iterator.hasNext());
        this.csDAO.unmarkAsAncestorOfBranch("cs2", "br1");
        iterator = this.csDAO.getChangeSetsInAncestryOfBranch("br1").iterator();
        Assert.assertEquals((String)"cs1 on branch not where expected", (Object)"cs1", (Object)((MyChangeSet)((Object)iterator.next())).getId());
        Assert.assertEquals((String)"cs3 on branch not where expected", (Object)"cs3", (Object)((MyChangeSet)((Object)iterator.next())).getId());
        Assert.assertFalse((String)"Unexpected changeset element on br1", (boolean)iterator.hasNext());
        Assert.assertTrue((String)"cs1 should have branch br1", (boolean)((MyChangeSet)this.csDAO.load("cs1")).getBranchesContributedTo().equals(Collections.singleton("br1")));
        Assert.assertTrue((String)"cs2 should not have branch br1", (boolean)((MyChangeSet)this.csDAO.load("cs2")).getBranchesContributedTo().equals(Collections.singleton("br2")));
        Assert.assertTrue((String)"cs3 should have branch br1", (boolean)((MyChangeSet)this.csDAO.load("cs3")).getBranchesContributedTo().equals(Collections.singleton("br1")));
        this.csDAO.unmarkAllAsAncestorOfBranch("br1");
        iterator = this.csDAO.getChangeSetsInAncestryOfBranch("br1").iterator();
        Assert.assertFalse((String)"Unexpected changeset element on br1", (boolean)iterator.hasNext());
        Assert.assertTrue((String)"cs1 should not have branch br1", (boolean)((MyChangeSet)this.csDAO.load("cs1")).getBranchesContributedTo().isEmpty());
        Assert.assertTrue((String)"cs2 should not have branch br1", (boolean)((MyChangeSet)this.csDAO.load("cs2")).getBranchesContributedTo().equals(Collections.singleton("br2")));
        Assert.assertTrue((String)"cs3 should not have branch br1", (boolean)((MyChangeSet)this.csDAO.load("cs3")).getBranchesContributedTo().isEmpty());
    }

    private MyChangeSet createChangeSet(String id, String author, String comment, GregorianCalendar cal) {
        MyChangeSet cs = new MyChangeSet(id, (ChangeSetDAO<FileRevision, MyChangeSet>)this.csDAO, this.fileRevDAOMock);
        cs.setAuthor(author);
        cs.setComment(comment);
        cs.setDate(cal.getTimeInMillis());
        return cs;
    }

    private MyChangeSet createChangeSet(String id, String ... parents) {
        MyChangeSet cs = this.createChangeSet(id, "author", "comment", new GregorianCalendar(2010, 7, 1));
        cs.setParents(Arrays.asList(parents));
        return cs;
    }

    @Test
    public void testGetCommitList() throws DbException, LicensePolicyException {
        MyChangeSet cs1 = this.createChangeSet("cs1", "testuser", "first change", new GregorianCalendar(2010, 7, 1));
        MyChangeSet cs2 = this.createChangeSet("cs2", "testuser", "second change", new GregorianCalendar(2010, 7, 2));
        this.csDAO.store((ChangeSetImpl)cs1);
        this.csDAO.store((ChangeSetImpl)cs2);
        List commitIds = this.csDAO.getChangeSetIds();
        Assert.assertEquals((long)2L, (long)commitIds.size());
        Assert.assertTrue((boolean)commitIds.contains("cs1"));
        Assert.assertTrue((boolean)commitIds.contains("cs2"));
        EasyMock.verify((Object[])new Object[]{this.fileRevDAOMock});
    }

    @Test
    public void testWorksWithClosedDb() throws DbException, LicensePolicyException, IOException {
        MyChangeSet cs1 = this.createChangeSet("cs1", "testuser", "first change", new GregorianCalendar(2010, 7, 1));
        this.csDAO.store((ChangeSetImpl)cs1);
        this.dbHandle.close();
        MyChangeSet loaded = (MyChangeSet)this.csDAO.load("cs1");
        Assert.assertEquals((Object)loaded.getId(), (Object)cs1.getId());
    }

    @Test
    public void testChangesetOrderingOnABranch() throws DbException, LicensePolicyException {
        MyChangeSet cs1 = this.createChangeSet("cs1", "testuser", "first change", new GregorianCalendar(2010, 7, 1));
        MyChangeSet cs2 = this.createChangeSet("cs2", "testuser", "second change", new GregorianCalendar(2010, 6, 1));
        MyChangeSet cs3 = this.createChangeSet("cs3", "testuser", "third change", new GregorianCalendar(2010, 7, 3));
        cs1.setBranch("trunk");
        cs2.setBranch("trunk");
        cs3.setBranch("trunk");
        cs2.setParents(Arrays.asList("cs1"));
        cs3.setParents(Arrays.asList("cs2"));
        this.csDAO.store((ChangeSetImpl)cs1);
        this.csDAO.store((ChangeSetImpl)cs2);
        this.csDAO.store((ChangeSetImpl)cs3);
        ListIterator it = this.csDAO.getChangeSets().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"cs1", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertEquals((Object)"cs2", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertEquals((Object)"cs3", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertFalse((boolean)it.hasNext());
        it = this.csDAO.getChangeSetsOnBranch("trunk", null).iterator();
        Assert.assertEquals((Object)"cs1", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertEquals((Object)"cs2", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertEquals((Object)"cs3", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testChangesetOrderingOnAParallelBranch() throws DbException, LicensePolicyException {
        MyChangeSet cs0 = this.createChangeSet("cs0", "testuser", "initial", new GregorianCalendar(2010, 7, 2));
        MyChangeSet cs1 = this.createChangeSet("cs1", "testuser", "first change", new GregorianCalendar(2010, 7, 1));
        MyChangeSet cs2 = this.createChangeSet("cs2", "testuser", "second change", new GregorianCalendar(2010, 6, 1));
        MyChangeSet cs3 = this.createChangeSet("cs3", "testuser", "third change", new GregorianCalendar(2010, 5, 3));
        cs0.setBranch("trunk");
        cs1.setBranch("trunk");
        cs2.setBranch("branchA");
        cs3.setBranch("trunk");
        cs1.setParents(Arrays.asList("cs0"));
        cs2.setParents(Arrays.asList("cs0"));
        cs3.setParents(Arrays.asList("cs1", "cs2"));
        this.csDAO.store((ChangeSetImpl)cs0);
        this.csDAO.store((ChangeSetImpl)cs1);
        this.csDAO.store((ChangeSetImpl)cs2);
        this.csDAO.store((ChangeSetImpl)cs3);
        ListIterator it = this.csDAO.getChangeSets().iterator();
        Assert.assertTrue((boolean)it.hasNext());
        Assert.assertEquals((Object)"cs0", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertEquals((Object)"cs2", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertEquals((Object)"cs1", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertEquals((Object)"cs3", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertFalse((boolean)it.hasNext());
        it = this.csDAO.getChangeSetsOnBranch("trunk", null).iterator();
        Assert.assertEquals((Object)"cs0", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertEquals((Object)"cs1", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertEquals((Object)"cs3", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertFalse((boolean)it.hasNext());
        it = this.csDAO.getChangeSetsOnBranch("branchA", null).iterator();
        Assert.assertEquals((Object)"cs2", (Object)((MyChangeSet)((Object)it.next())).getId());
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testChangeSetOrderingWithSameDates() throws DbException, LicensePolicyException {
        MyChangeSet cs0 = this.createChangeSet("cs0", "testuser", "initial", new GregorianCalendar(2010, 7, 2));
        MyChangeSet cs1 = this.createChangeSet("cs1", "testuser", "first change", new GregorianCalendar(2010, 7, 1));
        MyChangeSet cs2 = this.createChangeSet("cs2", "testuser", "second change", new GregorianCalendar(2010, 7, 1));
        MyChangeSet cs3 = this.createChangeSet("cs3", "testuser", "third change", new GregorianCalendar(2010, 7, 1));
        cs0.setBranch("trunk");
        cs1.setBranch("trunk");
        cs2.setBranch("trunk");
        cs3.setBranch("trunk");
        this.csDAO.store((ChangeSetImpl)cs0);
        this.csDAO.store((ChangeSetImpl)cs1);
        this.csDAO.store((ChangeSetImpl)cs2);
        this.csDAO.store((ChangeSetImpl)cs3);
        this.assertOrderForwards(this.csDAO.getChangeSets().iterator(), "cs1", "cs2", "cs3", "cs0");
    }

    @Test
    public void testGetChangeSetWithStartPosition() throws DbException, LicensePolicyException {
        MyChangeSet cs0 = this.createChangeSet("cs0", "testuser", "initial", new GregorianCalendar(2010, 7, 2));
        MyChangeSet cs1 = this.createChangeSet("cs1", "testuser", "first change", new GregorianCalendar(2010, 7, 1));
        MyChangeSet cs2 = this.createChangeSet("cs2", "testuser", "second change", new GregorianCalendar(2010, 6, 1));
        MyChangeSet cs3 = this.createChangeSet("cs3", "testuser", "third change", new GregorianCalendar(2010, 5, 3));
        cs0.setBranch("trunk");
        cs1.setBranch("trunk");
        cs2.setBranch("branchA");
        cs3.setBranch("trunk");
        cs1.setParents(Arrays.asList("cs0"));
        cs2.setParents(Arrays.asList("cs0"));
        cs3.setParents(Arrays.asList("cs1", "cs2"));
        this.csDAO.store((ChangeSetImpl)cs0);
        this.csDAO.store((ChangeSetImpl)cs1);
        this.csDAO.store((ChangeSetImpl)cs2);
        this.csDAO.store((ChangeSetImpl)cs3);
        this.assertOrderForwards(this.csDAO.getChangeSets().iterator(), "cs0", "cs2", "cs1", "cs3");
        this.assertOrderBackwards(this.csDAO.getChangeSets().iterator(), new String[0]);
        this.assertOrderForwards(this.csDAO.getChangeSets((ChangeSet)cs0).iterator(), "cs0", "cs2", "cs1", "cs3");
        this.assertOrderBackwards(this.csDAO.getChangeSets((ChangeSet)cs0).iterator(), new String[0]);
        this.assertOrderForwards(this.csDAO.getChangeSets((ChangeSet)cs2).iterator(), "cs2", "cs1", "cs3");
        this.assertOrderBackwards(this.csDAO.getChangeSets((ChangeSet)cs2).iterator(), "cs0");
        this.assertOrderForwards(this.csDAO.getChangeSets((ChangeSet)cs1).iterator(), "cs1", "cs3");
        this.assertOrderBackwards(this.csDAO.getChangeSets((ChangeSet)cs1).iterator(), "cs2", "cs0");
        this.assertOrderForwards(this.csDAO.getChangeSets((ChangeSet)cs3).iterator(), "cs3");
        this.assertOrderBackwards(this.csDAO.getChangeSets((ChangeSet)cs3).iterator(), "cs1", "cs2", "cs0");
    }

    @Test
    public void testGetNextAndPreviousChangeSet() throws DbException, LicensePolicyException {
        MyChangeSet cs0 = this.createChangeSet("cs0", "testuser", "initial", new GregorianCalendar(2010, 7, 2));
        MyChangeSet cs1 = this.createChangeSet("cs1", "testuser", "first change", new GregorianCalendar(2010, 7, 1));
        MyChangeSet cs2 = this.createChangeSet("cs2", "testuser", "second change", new GregorianCalendar(2010, 6, 1));
        MyChangeSet cs3 = this.createChangeSet("cs3", "testuser", "third change", new GregorianCalendar(2010, 5, 3));
        cs0.setBranch("trunk");
        cs1.setBranch("trunk");
        cs2.setBranch("branchA");
        cs3.setBranch("trunk");
        cs1.setParents(Arrays.asList("cs0"));
        cs2.setParents(Arrays.asList("cs0"));
        cs3.setParents(Arrays.asList("cs1", "cs2"));
        this.csDAO.store((ChangeSetImpl)cs0);
        this.csDAO.store((ChangeSetImpl)cs1);
        this.csDAO.store((ChangeSetImpl)cs2);
        this.csDAO.store((ChangeSetImpl)cs3);
        this.assertOrderNext((ChangeSetDAO<FileRevision, MyChangeSet>)this.csDAO, (ChangeSet)cs0, "cs2", "cs1", "cs3");
        this.assertOrderPrevious((ChangeSetDAO<FileRevision, MyChangeSet>)this.csDAO, (ChangeSet)cs0, new String[0]);
        this.assertOrderNext((ChangeSetDAO<FileRevision, MyChangeSet>)this.csDAO, (ChangeSet)cs2, "cs1", "cs3");
        this.assertOrderPrevious((ChangeSetDAO<FileRevision, MyChangeSet>)this.csDAO, (ChangeSet)cs2, "cs0");
        this.assertOrderNext((ChangeSetDAO<FileRevision, MyChangeSet>)this.csDAO, (ChangeSet)cs1, "cs3");
        this.assertOrderPrevious((ChangeSetDAO<FileRevision, MyChangeSet>)this.csDAO, (ChangeSet)cs1, "cs2", "cs0");
        this.assertOrderNext((ChangeSetDAO<FileRevision, MyChangeSet>)this.csDAO, (ChangeSet)cs3, new String[0]);
        this.assertOrderPrevious((ChangeSetDAO<FileRevision, MyChangeSet>)this.csDAO, (ChangeSet)cs3, "cs1", "cs2", "cs0");
    }

    private MyChangeSet[] initBranchMergeDataset() throws LicensePolicyException {
        MyChangeSet[] cs = new MyChangeSet[]{this.createChangeSet("0", "testuser", "commit 0", new GregorianCalendar(2010, 7, 10)), this.createChangeSet("1", "testuser", "commit 1", new GregorianCalendar(2010, 7, 11)), this.createChangeSet("2", "testuser", "commit 2", new GregorianCalendar(2010, 7, 12)), this.createChangeSet("3", "testuser", "commit 3", new GregorianCalendar(2010, 7, 13)), this.createChangeSet("4", "testuser", "commit 4", new GregorianCalendar(2010, 7, 14)), this.createChangeSet("5", "testuser", "commit 5", new GregorianCalendar(2010, 7, 15)), this.createChangeSet("6", "testuser", "commit 6", new GregorianCalendar(2010, 7, 16)), this.createChangeSet("7", "testuser", "commit 7", new GregorianCalendar(2010, 7, 17))};
        cs[0].setBranch("A");
        cs[1].setBranch("A");
        cs[2].setBranch("B");
        cs[3].setBranch("C");
        cs[4].setBranch("B");
        cs[5].setBranch("C");
        cs[6].setBranch("B");
        cs[7].setBranch("A");
        cs[1].setParents(Arrays.asList("0"));
        cs[2].setParents(Arrays.asList("0"));
        cs[3].setParents(Arrays.asList("0"));
        cs[4].setParents(Arrays.asList("2"));
        cs[5].setParents(Arrays.asList("3"));
        cs[6].setParents(Arrays.asList("4", "5"));
        cs[7].setParents(Arrays.asList("1", "6"));
        for (MyChangeSet c : cs) {
            this.csDAO.store((ChangeSetImpl)c);
        }
        return cs;
    }

    @Test
    public void testGetExistingParentDbIds() throws Exception {
        this.setupSparseChangesets();
        LongList parentsOfB = this.csDAO.getExistingParentDbIds(1L);
        LongList parentsOfF = this.csDAO.getExistingParentDbIds(4L);
        LongList parentsOfF1 = this.csDAO.getExistingParentDbIds(6L);
        LongList parentsOfG = this.csDAO.getExistingParentDbIds(8L);
        LongList parentsOfJ = this.csDAO.getExistingParentDbIds(11L);
        LongList parentsOfNonExistantDbId = this.csDAO.getExistingParentDbIds(999L);
        Assert.assertThat((Object)parentsOfB, (Matcher)Matchers.empty());
        Assert.assertThat((Object)parentsOfF, (Matcher)Matchers.contains((Object[])new Long[]{1L}));
        Assert.assertThat((Object)parentsOfF1, (Matcher)Matchers.contains((Object[])new Long[]{3L, 1L}));
        Assert.assertThat((Object)parentsOfG, (Matcher)Matchers.contains((Object[])new Long[]{4L}));
        Assert.assertThat((Object)parentsOfJ, (Matcher)Matchers.contains((Object[])new Long[]{9L, 10L, 6L}));
        Assert.assertThat((Object)parentsOfNonExistantDbId, (Matcher)Matchers.empty());
    }

    @Test
    public void shouldNotClearAncestorsOnBranchIfHeadMovesOverNotIndexedChangesets() throws Exception {
        this.setupSparseChangesets();
        Branch oldBranch = new Branch("branch", "F", BranchState.ACTIVE);
        this.csDAO.markAsAncestorOfBranch(oldBranch.getLatestChangeSetId(), oldBranch.getName());
        this.branchDAO.store(oldBranch, true);
        Set modifiedCsIds = this.csDAO.clearOnBranchesIfRefWarped(oldBranch, new Branch("branch", "J", BranchState.ACTIVE));
        ImmutableSet changesetsInBranch = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.csDAO.getChangeSetsInAncestryOfBranch("branch"), (Function)ChangeSet.TO_CSID));
        Assert.assertThat((Object)modifiedCsIds, (Matcher)Matchers.empty());
        Assert.assertThat((Object)changesetsInBranch, (Matcher)Matchers.contains((Object[])new String[]{"F"}));
    }

    @Test
    public void shouldClearAncestorsOnBranchIfHeadMovesToANonDescendantChangeset() throws Exception {
        this.setupSparseChangesets();
        Branch oldBranch = new Branch("branch", "F", BranchState.ACTIVE);
        this.csDAO.markAsAncestorOfBranch(oldBranch.getLatestChangeSetId(), oldBranch.getName());
        this.branchDAO.store(oldBranch, true);
        Set modifiedCsIds = this.csDAO.clearOnBranchesIfRefWarped(oldBranch, new Branch("branch", "B", BranchState.ACTIVE));
        ImmutableSet changesetsInBranch = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)this.csDAO.getChangeSetsInAncestryOfBranch("branch"), (Function)ChangeSet.TO_CSID));
        Assert.assertThat((Object)modifiedCsIds, (Matcher)Matchers.contains((Object[])new String[]{"F"}));
        Assert.assertThat((Object)changesetsInBranch, (Matcher)Matchers.empty());
    }

    private void setupSparseChangesets() throws LicensePolicyException {
        this.csDAO.updateParentGraph("A", (List)ImmutableList.of((Object)"Z"));
        this.csDAO.store((ChangeSetImpl)this.createChangeSet("B", "A"));
        this.csDAO.updateParentGraph("C", (List)ImmutableList.of((Object)"B"));
        this.csDAO.updateParentGraph("C1", (List)ImmutableList.of((Object)"B", (Object)"Z"));
        this.csDAO.updateParentGraph("D", (List)ImmutableList.of((Object)"C"));
        this.csDAO.store((ChangeSetImpl)this.createChangeSet("D1", "B"));
        this.csDAO.updateParentGraph("E", (List)ImmutableList.of((Object)"D"));
        this.csDAO.updateParentGraph("E1", (List)ImmutableList.of((Object)"D", (Object)"D1"));
        this.csDAO.store((ChangeSetImpl)this.createChangeSet("F", "E"));
        this.csDAO.store((ChangeSetImpl)this.createChangeSet("F1", "E1"));
        this.csDAO.store((ChangeSetImpl)this.createChangeSet("G", "F"));
        this.csDAO.store((ChangeSetImpl)this.createChangeSet("H", "G"));
        this.csDAO.store((ChangeSetImpl)this.createChangeSet("H1", "G"));
        this.csDAO.updateParentGraph("H2", (List)ImmutableList.of((Object)"F1"));
        this.csDAO.updateParentGraph("I", (List)ImmutableList.of((Object)"H", (Object)"H1", (Object)"H2"));
        this.csDAO.store((ChangeSetImpl)this.createChangeSet("J", "I"));
    }

    @Test
    public void testMarkChangesetBranche() throws Exception {
        MyChangeSet cs1 = this.createChangeSet("1", new String[0]);
        MyChangeSet cs2 = this.createChangeSet("2", new String[0]);
        MyChangeSet cs3 = this.createChangeSet("3", new String[0]);
        this.csDAO.store((ChangeSetImpl)cs1);
        this.csDAO.store((ChangeSetImpl)cs2);
        this.csDAO.store((ChangeSetImpl)cs3);
        this.csDAO.updateChangesetBranches("1", Arrays.asList("A", "B", "D"), Arrays.asList(new String[0]));
        this.csDAO.updateChangesetBranches("2", Arrays.asList("C", "B"), Arrays.asList(new String[0]));
        this.csDAO.updateChangesetBranches("3", Arrays.asList("A", "C"), Arrays.asList(new String[0]));
        this.csDAO.updateChangesetBranches("2", Arrays.asList("D"), Arrays.asList("C"));
        this.csDAO.updateChangesetBranches("1", Arrays.asList(new String[0]), Arrays.asList("B"));
        Set cs1Branches = ((MyChangeSet)this.csDAO.getChangeSet("1")).getBranchesContributedTo();
        Set cs2Branches = ((MyChangeSet)this.csDAO.getChangeSet("2")).getBranchesContributedTo();
        Set cs3Branches = ((MyChangeSet)this.csDAO.getChangeSet("3")).getBranchesContributedTo();
        ImmutableList onA = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.csDAO.getChangeSetsInAncestryOfBranch("A"), (Function)ChangeSet.TO_CSID));
        ImmutableList onB = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.csDAO.getChangeSetsInAncestryOfBranch("B"), (Function)ChangeSet.TO_CSID));
        ImmutableList onC = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.csDAO.getChangeSetsInAncestryOfBranch("C"), (Function)ChangeSet.TO_CSID));
        ImmutableList onD = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.csDAO.getChangeSetsInAncestryOfBranch("D"), (Function)ChangeSet.TO_CSID));
        Assert.assertThat((Object)cs1Branches, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"A", "D"}));
        Assert.assertThat((Object)cs2Branches, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"B", "D"}));
        Assert.assertThat((Object)cs3Branches, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"A", "C"}));
        Assert.assertThat((Object)onA, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"1", "3"}));
        Assert.assertThat((Object)onB, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"2"}));
        Assert.assertThat((Object)onC, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"3"}));
        Assert.assertThat((Object)onD, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"1", "2"}));
    }

    @Test
    public void testNextCrossBranchCommitsMidInsertion() throws Exception {
        MyChangeSet[] changeSets = this.initBranchMergeDataset();
        this.assertNextCrossBranchCommits((ChangeSet)this.csDAO.getChangeSet(changeSets[0].getId()), new String[0]);
        this.assertNextCrossBranchCommits((ChangeSet)this.csDAO.getChangeSet(changeSets[1].getId()), "2", "3");
        this.assertNextCrossBranchCommits((ChangeSet)this.csDAO.getChangeSet(changeSets[2].getId()), "3", "7");
        this.assertNextCrossBranchCommits((ChangeSet)this.csDAO.getChangeSet(changeSets[3].getId()), "4", "7");
        MyChangeSet insertion = this.createChangeSet("8", "testuser", "commit 8", new GregorianCalendar(2010, 7, 12, 1, 1));
        insertion.setBranch("D");
        insertion.setParents(Arrays.asList("1"));
        this.csDAO.store((ChangeSetImpl)insertion);
        this.assertNextCrossBranchCommits((ChangeSet)this.csDAO.getChangeSet(changeSets[0].getId()), new String[0]);
        this.assertNextCrossBranchCommits((ChangeSet)this.csDAO.getChangeSet(changeSets[1].getId()), "2", "3");
        this.assertNextCrossBranchCommits((ChangeSet)this.csDAO.getChangeSet(changeSets[2].getId()), "3", "7", "8");
        this.assertNextCrossBranchCommits((ChangeSet)this.csDAO.getChangeSet(changeSets[3].getId()), "4", "7");
        Assert.assertEquals((String)"inserted changeset has wrong position", (Object)((MyChangeSet)this.csDAO.getNextChangeSet((ChangeSet)insertion)).getId(), (Object)changeSets[3].getId());
        Assert.assertEquals((String)"inserted changeset has wrong position", (Object)((MyChangeSet)this.csDAO.getPreviousChangeSet((ChangeSet)insertion)).getId(), (Object)changeSets[2].getId());
        this.assertNextCrossBranchCommits((ChangeSet)this.csDAO.getChangeSet(insertion.getId()), "3", "4", "7");
    }

    private void assertNextCrossBranchCommits(ChangeSet cs, String ... expectedIds) {
        Assert.assertEquals((String)(cs.getId() + " has wrong number of next cross branch commits"), (long)expectedIds.length, (long)cs.getNextCrossBranchCommits().size());
        for (String expected : expectedIds) {
            Assert.assertTrue((String)(cs.getId() + " has the wrong next branch commits"), (boolean)cs.getNextCrossBranchCommits().contains(expected));
        }
    }

    @Test
    public void testGetChangeSetWithBranchAndStartPosition() throws DbException, LicensePolicyException {
        MyChangeSet[] cs = this.initBranchMergeDataset();
        this.assertOrderForwards(this.csDAO.getChangeSetsOnBranch("A", null).iterator(), "0", "1", "7");
        this.assertOrderBackwards(this.csDAO.getChangeSetsOnBranch("A", null).iterator(), new String[0]);
        this.assertOrderForwards(this.csDAO.getChangeSetsOnBranch("A", (ChangeSet)cs[0]).iterator(), "0", "1", "7");
        this.assertOrderBackwards(this.csDAO.getChangeSetsOnBranch("A", (ChangeSet)cs[0]).iterator(), new String[0]);
        this.assertOrderForwards(this.csDAO.getChangeSetsOnBranch("A", (ChangeSet)cs[1]).iterator(), "1", "7");
        this.assertOrderBackwards(this.csDAO.getChangeSetsOnBranch("A", (ChangeSet)cs[1]).iterator(), "0");
        this.assertOrderForwards(this.csDAO.getChangeSetsOnBranch("A", (ChangeSet)cs[7]).iterator(), "7");
        this.assertOrderBackwards(this.csDAO.getChangeSetsOnBranch("A", (ChangeSet)cs[7]).iterator(), "1", "0");
        this.assertOrderForwards(this.csDAO.getChangeSetsOnBranch("A", (ChangeSet)cs[5]).iterator(), "7");
        this.assertOrderBackwards(this.csDAO.getChangeSetsOnBranch("A", (ChangeSet)cs[7]).iterator(), "1", "0");
        this.assertOrderForwards(this.csDAO.getChangeSetsOnBranch("B", null).iterator(), "2", "4", "6");
        this.assertOrderBackwards(this.csDAO.getChangeSetsOnBranch("B", null).iterator(), new String[0]);
        this.assertOrderForwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[0]).iterator(), "2", "4", "6");
        this.assertOrderBackwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[0]).iterator(), new String[0]);
        this.assertOrderForwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[2]).iterator(), "2", "4", "6");
        this.assertOrderBackwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[2]).iterator(), new String[0]);
        this.assertOrderForwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[3]).iterator(), "4", "6");
        this.assertOrderBackwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[3]).iterator(), "2");
        this.assertOrderForwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[4]).iterator(), "4", "6");
        this.assertOrderBackwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[4]).iterator(), "2");
        this.assertOrderForwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[5]).iterator(), "6");
        this.assertOrderBackwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[5]).iterator(), "4", "2");
        this.assertOrderForwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[6]).iterator(), "6");
        this.assertOrderBackwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[6]).iterator(), "4", "2");
        this.assertOrderForwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[7]).iterator(), new String[0]);
        this.assertOrderBackwards(this.csDAO.getChangeSetsOnBranch("B", (ChangeSet)cs[7]).iterator(), "6", "4", "2");
    }

    @Test
    public void testGetTip() throws LicensePolicyException {
        MyChangeSet[] cs = this.initBranchMergeDataset();
        this.assertTip(cs[7], "A");
        this.assertTip(cs[7], "A", "B");
        this.assertTip(cs[7], "A", "B", "C");
        this.assertTip(cs[6], "B");
        this.assertTip(cs[6], "B", "C");
        this.assertTip(cs[5], "C");
    }

    private void assertTip(MyChangeSet expected, String ... branches) {
        Assert.assertEquals((Object)expected.getId(), (Object)((MyChangeSet)this.csDAO.getTipChangeSet((Set)Sets.newHashSet((Object[])branches))).getId());
    }

    private void assertOrderForwards(ListIterator<? extends ChangeSet> it, String ... csIds) {
        ArrayList<String> actualIds = new ArrayList<String>();
        while (it.hasNext()) {
            actualIds.add(it.next().getId());
        }
        TestCase.assertEquals(Arrays.asList(csIds), actualIds);
    }

    private void assertOrderBackwards(ListIterator<? extends ChangeSet> it, String ... csIds) {
        ArrayList<String> actualIds = new ArrayList<String>();
        while (it.hasPrevious()) {
            actualIds.add(it.previous().getId());
        }
        TestCase.assertEquals(Arrays.asList(csIds), actualIds);
    }

    private void assertOrderNext(ChangeSetDAO<FileRevision, MyChangeSet> csDAO, ChangeSet cs0, String ... csIds) {
        LinkedList<String> csQueue = new LinkedList<String>(Arrays.asList(csIds));
        ChangeSet cs = cs0;
        cs = csDAO.getNextChangeSet(cs);
        while (cs != null) {
            Assert.assertEquals(csQueue.remove(), (Object)cs.getId());
            cs = csDAO.getNextChangeSet(cs);
        }
        Assert.assertTrue((boolean)csQueue.isEmpty());
    }

    private void assertOrderPrevious(ChangeSetDAO<FileRevision, MyChangeSet> csDAO, ChangeSet cs0, String ... csIds) {
        LinkedList<String> csQueue = new LinkedList<String>(Arrays.asList(csIds));
        ChangeSet cs = cs0;
        cs = csDAO.getPreviousChangeSet(cs);
        while (cs != null) {
            Assert.assertEquals(csQueue.remove(), (Object)cs.getId());
            cs = csDAO.getPreviousChangeSet(cs);
        }
        Assert.assertTrue((boolean)csQueue.isEmpty());
    }

    private static class MyChangeSetDAO
    extends CommonChangeSetDAO<FileRevision, MyChangeSet, CommonStringTables> {
        public MyChangeSetDAO(InfinityDbHandle dbh, CommonStringTables stringTables, FileRevisionDAO<FileRevision> fileRevDAO, LicenseEnforcer lm) {
            super(new RepositoryStatus(CommonChangeSetDAOTest.REPO_NAME), dbh, stringTables, fileRevDAO, lm);
        }

        public MyChangeSet createChangeSet(String csid) {
            return new MyChangeSet(csid, (ChangeSetDAO<FileRevision, MyChangeSet>)this, (FileRevisionDAO<FileRevision>)this.fileRevDAO);
        }
    }

    private static class MyChangeSet
    extends ChangeSetImpl<FileRevision> {
        protected MyChangeSet() {
        }

        public MyChangeSet(String csid, ChangeSetDAO<FileRevision, MyChangeSet> csDAO, FileRevisionDAO<FileRevision> dao) {
            super(csid, csDAO, dao);
        }

        public int compareSecondarySort(ChangeSet bound) {
            return 0;
        }

        public Set<Integer> getReviewIds() throws DbException {
            return null;
        }

        public String toString() {
            return this.getId();
        }
    }
}

