/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.rep.DummyChangeSet;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.MutableChangeSet;
import com.cenqua.fisheye.rep.Position;
import com.cenqua.fisheye.rep.impl.ChangeSetAncestryProcessor;
import com.cenqua.fisheye.rep.impl.ChangeSetDAO;
import java.util.Arrays;
import java.util.List;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangesetAncestryProcessorTest {
    private ChangeSetAncestryProcessor processor;
    private ChangeSetDAO<FileRevision, DummyChangeSet<FileRevision>> csDAO;
    private List<String> branches = Arrays.asList("branchA", "branchB");
    private MutableChangeSet cs;

    @Before
    public void setup() {
        this.csDAO = (ChangeSetDAO)EasyMock.createMock(ChangeSetDAO.class);
        this.processor = new ChangeSetAncestryProcessor(this.csDAO);
        this.cs = new DummyChangeSet();
        this.cs.setId("csid1");
        this.cs.setBranches(this.branches);
    }

    @Test
    public void testNoParents() throws Exception {
        org.easymock.EasyMock.expect((Object)this.csDAO.getLatestChangesetOnBranchUpTo("branchA", "csid1", false)).andReturn(null).once();
        org.easymock.EasyMock.expect((Object)this.csDAO.getLatestChangesetOnBranchUpTo("branchB", "csid1", false)).andReturn(null).once();
        org.easymock.EasyMock.expect((Object)this.csDAO.getLatestChangesetOnBranch("branchA")).andReturn(null).once();
        org.easymock.EasyMock.expect((Object)this.csDAO.getLatestChangesetOnBranch("branchB")).andReturn(null).once();
        EasyMock.replay((Object[])new Object[]{this.csDAO});
        Assert.assertFalse((boolean)this.processor.process(this.cs));
        Assert.assertNotNull((Object)this.cs.getParents());
        Assert.assertTrue((boolean)this.cs.getParents().isEmpty());
        EasyMock.verify((Object[])new Object[]{this.csDAO});
    }

    @Test
    public void testParents() throws Exception {
        DummyChangeSet parent1 = new DummyChangeSet();
        DummyChangeSet parent2 = new DummyChangeSet();
        parent1.setId("p1");
        parent2.setId("p2");
        org.easymock.EasyMock.expect((Object)this.csDAO.getLatestChangesetOnBranchUpTo("branchA", "csid1", false)).andReturn(parent1).once();
        org.easymock.EasyMock.expect((Object)this.csDAO.getLatestChangesetOnBranchUpTo("branchB", "csid1", false)).andReturn(parent2).once();
        EasyMock.replay((Object[])new Object[]{this.csDAO});
        Assert.assertTrue((boolean)this.processor.process(this.cs));
        Assert.assertNotNull((Object)this.cs.getParents());
        Assert.assertEquals((long)2L, (long)this.cs.getParents().size());
        Assert.assertTrue((boolean)this.cs.getParents().contains("p1"));
        Assert.assertTrue((boolean)this.cs.getParents().contains("p2"));
        EasyMock.verify((Object[])new Object[]{this.csDAO});
    }

    @Test
    public void testParentsNoUpdate() throws Exception {
        DummyChangeSet parent1 = new DummyChangeSet();
        DummyChangeSet parent2 = new DummyChangeSet();
        parent1.setId("p1");
        parent2.setId("p2");
        parent1.setPosition(new Position(new long[]{100L}));
        parent2.setPosition(new Position(new long[]{200L}));
        org.easymock.EasyMock.expect((Object)this.csDAO.getLatestChangesetOnBranchUpTo("branchA", "csid1", false)).andReturn(parent1).once();
        org.easymock.EasyMock.expect((Object)this.csDAO.getLatestChangesetOnBranchUpTo("branchB", "csid1", false)).andReturn(parent2).once();
        EasyMock.replay((Object[])new Object[]{this.csDAO});
        this.cs.setParents(Arrays.asList("p1", "p2"));
        Assert.assertFalse((boolean)this.processor.process(this.cs));
        Assert.assertNotNull((Object)this.cs.getParents());
        Assert.assertEquals((long)2L, (long)this.cs.getParents().size());
        Assert.assertTrue((boolean)this.cs.getParents().contains("p1"));
        Assert.assertTrue((boolean)this.cs.getParents().contains("p2"));
        EasyMock.verify((Object[])new Object[]{this.csDAO});
    }
}

