/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.impl;

import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.impl.BaseUpgradeTask;
import com.infinitydb.Attribute;
import com.infinitydb.Cu;
import com.infinitydb.CuAppendable;
import com.infinitydb.EntityClass;
import com.infinitydb.InfinityDB;
import com.infinitydb.ItemSpace;
import com.infinitydb.Schema;
import java.io.File;
import java.io.IOException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BaseUpgradeTaskTest {
    private static final Schema SCHEMA = new Schema(Cu.alloc().append("test"));
    private static final EntityClass E1 = new EntityClass(1L, SCHEMA);
    private static final EntityClass E2 = new EntityClass(2L, SCHEMA);
    private static final EntityClass E3 = new EntityClass(3L, SCHEMA);
    private static final Attribute A1 = new Attribute(1L, SCHEMA);
    private static final Attribute A2 = new Attribute(2L, SCHEMA);
    private static final Attribute A3 = new Attribute(3L, SCHEMA);
    private static final Cu[] E1_DATA = BaseUpgradeTaskTest.createTestData(E1, E1, A2);
    private static final Cu[] E3_DATA = BaseUpgradeTaskTest.createTestData(E3, E3, A2);
    private static final Cu[] E1_DATA_COPIED_TO_E2 = BaseUpgradeTaskTest.createTestData(E2, E1, A2);
    private static final Cu[] E1_DATA_A2_MOVED_TO_A3 = BaseUpgradeTaskTest.createTestData(E1, E1, A3);
    private InfinityDB db;
    private File dbFile;
    private BaseUpgradeTask upgradeTask;

    @Before
    public void createInfDbDatabase() throws Exception {
        this.dbFile = File.createTempFile("upgradeTaskTest", "infdb");
        this.db = InfinityDB.create((String)this.dbFile.getAbsolutePath(), (boolean)true);
        this.upgradeTask = new BaseUpgradeTask(){

            protected String getTaskId() {
                return null;
            }

            protected int getTargetedSchemaVersion(ScmType scmType) {
                return 0;
            }

            protected void doUpgrade(RepositoryEngine engine, RepositoryStatus status) throws DbException {
            }
        };
        for (Cu cu : BaseUpgradeTaskTest.createTestData(E1, E1, A2)) {
            this.db.insert(cu);
        }
        for (Cu cu : BaseUpgradeTaskTest.createTestData(E3, E3, A2)) {
            this.db.insert(cu);
        }
        this.db.commit();
    }

    @After
    public void deleteInfDbDatabase() throws Exception {
        this.db.close();
        this.dbFile.delete();
    }

    private void assertNotEmpty(EntityClass entity) throws IOException {
        Cu cu = Cu.alloc().append((CuAppendable)entity);
        int offset = cu.length();
        Assert.assertTrue((boolean)this.db.next(cu, offset));
    }

    private void assertEmpty(EntityClass entity) throws IOException {
        Cu cu = Cu.alloc().append((CuAppendable)entity);
        int offset = cu.length();
        Assert.assertFalse((boolean)this.db.next(cu, offset));
    }

    private static Cu[] createTestData(EntityClass entity, EntityClass dataEntity, Attribute a2Attribute) {
        return new Cu[]{Cu.alloc().append((CuAppendable)entity).append(1L).append((CuAppendable)A1).append(dataEntity + ".1.A1.1"), Cu.alloc().append((CuAppendable)entity).append(1L).append((CuAppendable)A1).append(dataEntity + ".1.A1.2"), Cu.alloc().append((CuAppendable)entity).append(1L).append((CuAppendable)a2Attribute).append(dataEntity + ".1.A2.1"), Cu.alloc().append((CuAppendable)entity).append(1L).append((CuAppendable)a2Attribute).append(dataEntity + ".1.A2.2"), Cu.alloc().append((CuAppendable)entity).append(2L).append((CuAppendable)A1).append(dataEntity + ".2.A1.1"), Cu.alloc().append((CuAppendable)entity).append(2L).append((CuAppendable)A1).append(dataEntity + ".2.A1.2"), Cu.alloc().append((CuAppendable)entity).append(2L).append((CuAppendable)a2Attribute).append(dataEntity + ".2.A2.1"), Cu.alloc().append((CuAppendable)entity).append(2L).append((CuAppendable)a2Attribute).append(dataEntity + ".2.A2.2")};
    }

    private void assertDataAt(EntityClass entity, Cu[] expectedData) throws IOException {
        Cu cu = Cu.alloc().append((CuAppendable)entity);
        int offset = cu.length();
        for (int i = 0; i < expectedData.length; ++i) {
            Assert.assertTrue((String)("another row was expected in " + entity + "; i = " + i), (boolean)this.db.next(cu, offset));
            Assert.assertEquals((String)("the Cu's don't match!; i = " + i), (Object)expectedData[i], (Object)cu);
        }
        Assert.assertFalse((String)"no more data was expected", (boolean)this.db.next(cu, offset));
    }

    @Test
    public void testClearDB() throws Exception {
        this.assertNotEmpty(E1);
        this.upgradeTask.clearTable((ItemSpace)this.db, E1);
        this.assertEmpty(E1);
        this.assertDataAt(E3, BaseUpgradeTaskTest.createTestData(E3, E3, A2));
    }

    @Test
    public void testCloneDB() throws Exception {
        Assert.assertTrue((boolean)this.upgradeTask.cloneTable((ItemSpace)this.db, E1, E2));
        this.assertDataAt(E1, E1_DATA);
        this.assertDataAt(E2, E1_DATA_COPIED_TO_E2);
        this.assertDataAt(E3, E3_DATA);
        Assert.assertFalse((boolean)this.upgradeTask.cloneTable((ItemSpace)this.db, E1, E2));
        this.assertDataAt(E1, E1_DATA);
        this.assertDataAt(E2, E1_DATA_COPIED_TO_E2);
        this.assertDataAt(E3, E3_DATA);
    }

    @Test
    public void testMoveDB() throws Exception {
        Assert.assertTrue((boolean)this.upgradeTask.moveTable((ItemSpace)this.db, E1, E2));
        this.assertEmpty(E1);
        this.assertDataAt(E2, E1_DATA_COPIED_TO_E2);
        this.assertDataAt(E3, E3_DATA);
        Assert.assertFalse((boolean)this.upgradeTask.moveTable((ItemSpace)this.db, E1, E2));
        this.assertEmpty(E1);
        this.assertDataAt(E2, E1_DATA_COPIED_TO_E2);
        this.assertDataAt(E3, E3_DATA);
    }

    @Test
    public void testMoveAttribute() throws Exception {
        this.upgradeTask.moveAttribute((ItemSpace)this.db, A2, A3, E1);
        this.assertDataAt(E1, E1_DATA_A2_MOVED_TO_A3);
        this.upgradeTask.moveAttribute((ItemSpace)this.db, A2, A3, E1);
        this.assertDataAt(E1, E1_DATA_A2_MOVED_TO_A3);
    }

    @Test
    public void testDeleteAttribute() throws Exception {
        this.assertDataAt(E1, new Cu[]{Cu.alloc().append((CuAppendable)E1).append(1L).append((CuAppendable)A1).append(E1 + ".1.A1.1"), Cu.alloc().append((CuAppendable)E1).append(1L).append((CuAppendable)A1).append(E1 + ".1.A1.2"), Cu.alloc().append((CuAppendable)E1).append(1L).append((CuAppendable)A2).append(E1 + ".1.A2.1"), Cu.alloc().append((CuAppendable)E1).append(1L).append((CuAppendable)A2).append(E1 + ".1.A2.2"), Cu.alloc().append((CuAppendable)E1).append(2L).append((CuAppendable)A1).append(E1 + ".2.A1.1"), Cu.alloc().append((CuAppendable)E1).append(2L).append((CuAppendable)A1).append(E1 + ".2.A1.2"), Cu.alloc().append((CuAppendable)E1).append(2L).append((CuAppendable)A2).append(E1 + ".2.A2.1"), Cu.alloc().append((CuAppendable)E1).append(2L).append((CuAppendable)A2).append(E1 + ".2.A2.2")});
        this.upgradeTask.clearAttribute((ItemSpace)this.db, A1, E1);
        this.assertDataAt(E1, new Cu[]{Cu.alloc().append((CuAppendable)E1).append(1L).append((CuAppendable)A2).append(E1 + ".1.A2.1"), Cu.alloc().append((CuAppendable)E1).append(1L).append((CuAppendable)A2).append(E1 + ".1.A2.2"), Cu.alloc().append((CuAppendable)E1).append(2L).append((CuAppendable)A2).append(E1 + ".2.A2.1"), Cu.alloc().append((CuAppendable)E1).append(2L).append((CuAppendable)A2).append(E1 + ".2.A2.2")});
        this.upgradeTask.clearAttribute((ItemSpace)this.db, A2, E1);
        this.assertDataAt(E1, new Cu[0]);
    }
}

