/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.rep.blame.RevisionCacheBasedRevIdToAuthorMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class RevisionCacheBasedRevIdToAuthorMapTest {
    @Test
    public void testGetFromRevisionCacheOnlyOnce() throws Exception {
        RevisionCache mockRevisionCache = (RevisionCache)Mockito.mock(RevisionCache.class);
        AssertionError exception = new AssertionError((Object)"Cache should be contacted only once");
        Mockito.when((Object)mockRevisionCache.getAuthorOfRevision(0)).thenReturn((Object)"author0").thenThrow(new Throwable[]{exception});
        Mockito.when((Object)mockRevisionCache.getAuthorOfRevision(1)).thenReturn((Object)"author1").thenThrow(new Throwable[]{exception});
        Mockito.when((Object)mockRevisionCache.getAuthorOfRevision(2)).thenReturn(null).thenThrow(new Throwable[]{exception});
        RevisionCacheBasedRevIdToAuthorMap revIdToAuthorMap = new RevisionCacheBasedRevIdToAuthorMap(() -> mockRevisionCache);
        Assert.assertEquals((Object)"author0", (Object)revIdToAuthorMap.getAuthor(0).get());
        Assert.assertEquals((Object)"author0", (Object)revIdToAuthorMap.getAuthor(0).get());
        Assert.assertEquals((Object)"author1", (Object)revIdToAuthorMap.getAuthor(1).get());
        Assert.assertEquals((Object)"author1", (Object)revIdToAuthorMap.getAuthor(1).get());
        Assert.assertFalse((boolean)revIdToAuthorMap.getAuthor(2).isPresent());
        Assert.assertFalse((boolean)revIdToAuthorMap.getAuthor(2).isPresent());
    }
}

