/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.rep.blame.HunkToHunkZeroBasedConverter;
import com.cenqua.fisheye.rep.blame.HunkZeroBased;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HunkToHunkZeroBasedConverterTest {
    private HunkToHunkZeroBasedConverter converter;

    @Before
    public void setUp() throws Exception {
        this.converter = new HunkToHunkZeroBasedConverter();
    }

    @Test
    public void testAddBeginning() throws Exception {
        Hunk input = new Hunk(0, 1, 0, 5);
        HunkZeroBased actual = this.converter.convertSingleHunk(input);
        Assert.assertEquals((Object)new HunkZeroBased(0, 0, 0, 5), (Object)actual);
    }

    @Test
    public void testAddMiddle() throws Exception {
        Hunk input = new Hunk(100, 101, 0, 5);
        HunkZeroBased actual = this.converter.convertSingleHunk(input);
        Assert.assertEquals((Object)new HunkZeroBased(100, 0, 100, 5), (Object)actual);
    }

    @Test
    public void testRemoveBeginning() throws Exception {
        Hunk input = new Hunk(1, 0, 5, 0);
        HunkZeroBased actual = this.converter.convertSingleHunk(input);
        Assert.assertEquals((Object)new HunkZeroBased(0, 5, 0, 0), (Object)actual);
    }

    @Test
    public void testRemoveMiddle() throws Exception {
        Hunk input = new Hunk(101, 100, 5, 0);
        HunkZeroBased actual = this.converter.convertSingleHunk(input);
        Assert.assertEquals((Object)new HunkZeroBased(100, 5, 100, 0), (Object)actual);
    }

    @Test
    public void testMultiple() throws Exception {
        ImmutableList input = ImmutableList.of((Object)new Hunk(0, 1, 0, 5), (Object)new Hunk(100, 101, 0, 5), (Object)new Hunk(1, 0, 5, 0), (Object)new Hunk(101, 100, 5, 0));
        List actual = this.converter.convert((List)input);
        Assert.assertEquals((Object)ImmutableList.of((Object)new HunkZeroBased(0, 0, 0, 5), (Object)new HunkZeroBased(100, 0, 100, 5), (Object)new HunkZeroBased(0, 5, 0, 0), (Object)new HunkZeroBased(100, 5, 100, 0)), (Object)actual);
    }
}

