/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep.blame;

import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.blame.AuthorBlameException;
import com.cenqua.fisheye.rep.blame.DefaultBlameChunksCalculator;
import com.cenqua.fisheye.rep.blame.HunkZeroBased;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class DefaultBlameChunksCalculatorTest {
    @Test
    public void testEmptyHunkAndEmptyFile() throws Exception {
        ImmutableList blameChunks = ImmutableList.of();
        ImmutableList hunks = ImmutableList.of();
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 2);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[]"));
    }

    @Test
    public void testRemoveNothingFromNothing() throws Exception {
        ImmutableList blameChunks = ImmutableList.of();
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(0, 0, 0, 0));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[]"));
    }

    @Test
    public void testEmptyHunkAndNonEmptyFile() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 2, 100));
        ImmutableList hunks = ImmutableList.of();
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 2);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-2:100]"));
    }

    @Test
    public void testAddLinesToEmptyFile() throws Exception {
        ImmutableList blameChunks = ImmutableList.of();
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(0, 0, 0, 5));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 2);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-5:2]"));
    }

    @Test
    public void testAddLinesAtBeginOfChunk() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 10, 10, 2));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(0, 0, 0, 5));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-5:100, 5-15:1, 15-25:2]"));
    }

    @Test
    public void testAddLinesInMiddleOfChunk() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 10, 10, 2));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(3, 0, 3, 5));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-3:1, 3-8:100, 8-15:1, 15-25:2]"));
    }

    @Test
    public void testAddLinesAtEndOfChunk() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 10, 10, 2));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(10, 0, 10, 5));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-10:1, 10-15:100, 15-25:2]"));
    }

    @Test
    public void testDeleteLinesAtBeginOfChunk() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 10, 10, 2));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(0, 5, 0, 0));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-5:1, 5-15:2]"));
    }

    @Test
    public void testDeleteLinesInMiddleOfChunk() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 10, 10, 2));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(3, 5, 3, 0));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-3:1, 3-5:1, 5-15:2]"));
    }

    @Test
    public void testDeleteLinesAtEndOfChunk() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 10, 10, 2));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(5, 5, 5, 0));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-5:1, 5-15:2]"));
    }

    @Test
    public void testDeleteLinesBetweenChunks() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 10, 10, 2));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(8, 5, 8, 0));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-8:1, 8-15:2]"));
    }

    @Test
    public void testDeleteLinesBetweenManyChunks() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 10, 10, 2), (Object)new BlameChunk(20, 20, 10, 3), (Object)new BlameChunk(30, 30, 10, 4));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(8, 30, 8, 0));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-8:1, 8-10:4]"));
    }

    @Test
    public void testModifyLinesAtBeginOfChunk() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 10, 10, 2));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(0, 5, 0, 2));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-2:100, 2-7:1, 7-17:2]"));
    }

    @Test
    public void testModifyLinesInMiddleOfChunk() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 10, 10, 2));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(3, 5, 3, 2));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-3:1, 3-5:100, 5-7:1, 7-17:2]"));
    }

    @Test
    public void testModifyLinesAtEndOfChunk() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 10, 10, 2));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(5, 5, 5, 2));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-5:1, 5-7:100, 7-17:2]"));
    }

    @Test
    public void testModifyLinesBetweenChunks() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 10, 10, 2));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(8, 5, 8, 2));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-8:1, 8-10:100, 10-17:2]"));
    }

    @Test
    public void testModifyLinesBetweenManyChunks() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 1), (Object)new BlameChunk(10, 10, 10, 2), (Object)new BlameChunk(20, 20, 10, 3), (Object)new BlameChunk(30, 30, 10, 4));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(8, 25, 8, 2));
        List calculated = new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
        Assert.assertThat((Object)calculated.toString(), (Matcher)Matchers.is((Object)"[0-8:1, 8-10:100, 10-17:4]"));
    }

    @Test(expected=AuthorBlameException.class)
    public void testAddHunkOutsideOfRange() throws Exception {
        ImmutableList blameChunks = ImmutableList.of();
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(5, 0, 5, 1));
        new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
    }

    @Test(expected=AuthorBlameException.class)
    public void testRemoveHunkOutsideOfRange() throws Exception {
        ImmutableList blameChunks = ImmutableList.of();
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(0, 1, 0, 0));
        new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
    }

    @Test(expected=AuthorBlameException.class)
    public void testRemoveHunkThatWouldGoBeyondLineZero() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 1, 100));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(0, 2, 0, 1));
        new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
    }

    @Test(expected=AuthorBlameException.class)
    public void testModifyHunkOutsideOfRange() throws Exception {
        ImmutableList blameChunks = ImmutableList.of();
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(0, 1, 0, 1));
        new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
    }

    @Test(expected=AuthorBlameException.class)
    public void testBlameStartsAboveLine0() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(1, 0, 1, 0));
        ImmutableList hunks = ImmutableList.of();
        new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
    }

    @Test(expected=AuthorBlameException.class)
    public void testBlameHasAGap() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 1, 0), (Object)new BlameChunk(3, 0, 1, 1));
        ImmutableList hunks = ImmutableList.of();
        new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
    }

    @Test(expected=AuthorBlameException.class)
    public void testBlameHasAnOverlap() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 2, 0), (Object)new BlameChunk(1, 0, 2, 1));
        ImmutableList hunks = ImmutableList.of();
        new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
    }

    @Test(expected=AuthorBlameException.class)
    public void testOverlappingHunksFrom() throws Exception {
        ImmutableList blameChunks = ImmutableList.of((Object)new BlameChunk(0, 0, 10, 0));
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(4, 2, 4, 0), (Object)new HunkZeroBased(5, 2, 3, 0));
        new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
    }

    @Test(expected=AuthorBlameException.class)
    public void testHunksOutOfOrder() throws Exception {
        ImmutableList blameChunks = ImmutableList.of();
        ImmutableList hunks = ImmutableList.of((Object)new HunkZeroBased(0, 0, 1, 1), (Object)new HunkZeroBased(0, 0, 0, 1));
        new DefaultBlameChunksCalculator().applyHunks((List)blameChunks, (List)hunks, 100);
    }
}

